/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.rules;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Predicate;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.interpreter.Bindables;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRule;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptRuleOperand;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Project;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.RelFactories;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.TableScan;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.runtime.PredicateImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ProjectableFilterableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelBuilderFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableIntList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.mapping.Mapping;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public abstract class ProjectTableScanRule
extends RelOptRule {
    public static final Predicate<TableScan> PREDICATE = new PredicateImpl<TableScan>(){

        @Override
        public boolean test(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final ProjectTableScanRule INSTANCE = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(TableScan.class, null, PREDICATE, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, project, scan);
        }
    };
    public static final ProjectTableScanRule INTERPRETER = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(EnumerableInterpreter.class, ProjectTableScanRule.operand(TableScan.class, null, PREDICATE, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, project, scan);
        }
    };

    public ProjectTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList<RexNode> filters;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        Mappings.TargetMapping mapping = project.getMapping();
        if (mapping == null || Mappings.isIdentity(mapping)) {
            return;
        }
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters = bindableScan.filters;
            projects = bindableScan.projects;
        } else {
            filters = ImmutableList.of();
            projects = scan.identity();
        }
        List<Integer> projects2 = Mappings.apply((Mapping)mapping, projects);
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filters, projects2));
    }
}

