/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.schema;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableMap;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.DataContext;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.CalciteConnectionConfig;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.CalciteConnectionConfigImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.CalciteConnectionProperty;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteConnection;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.QueryProvider;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Queryable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Types;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.materialize.Lattice;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelProtoDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.FilterableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Function;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.FunctionParameter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Path;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ProjectableFilterableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.QueryableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ScalarFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ScannableTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Schema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaPlus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.Table;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelRunner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Schemas {
    private static final com.alibaba.lindorm.thirdparty.com.google.common.base.Function<CalciteSchema.LatticeEntry, CalciteSchema.TableEntry> TO_TABLE_ENTRY = new com.alibaba.lindorm.thirdparty.com.google.common.base.Function<CalciteSchema.LatticeEntry, CalciteSchema.TableEntry>(){

        @Override
        public CalciteSchema.TableEntry apply(CalciteSchema.LatticeEntry entry) {
            CalciteSchema.TableEntry starTable = entry.getStarTable();
            assert (starTable.getTable().getJdbcTableType() == Schema.TableType.STAR);
            return entry.getStarTable();
        }
    };
    private static final com.alibaba.lindorm.thirdparty.com.google.common.base.Function<CalciteSchema.LatticeEntry, Lattice> TO_LATTICE = new com.alibaba.lindorm.thirdparty.com.google.common.base.Function<CalciteSchema.LatticeEntry, Lattice>(){

        @Override
        public Lattice apply(CalciteSchema.LatticeEntry entry) {
            return entry.getLattice();
        }
    };

    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static CalciteSchema.FunctionEntry resolve(RelDataTypeFactory typeFactory, String name, Collection<CalciteSchema.FunctionEntry> functionEntries, List<RelDataType> argumentTypes) {
        ArrayList<CalciteSchema.FunctionEntry> matches = new ArrayList<CalciteSchema.FunctionEntry>();
        for (CalciteSchema.FunctionEntry entry : functionEntries) {
            if (!Schemas.matches(typeFactory, entry.getFunction(), argumentTypes)) continue;
            matches.add(entry);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CalciteSchema.FunctionEntry)matches.get(0);
            }
        }
        throw new RuntimeException("More than one match for " + name + " with arguments " + argumentTypes);
    }

    private static boolean matches(RelDataTypeFactory typeFactory, Function member, List<RelDataType> argumentTypes) {
        List<FunctionParameter> parameters = member.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            FunctionParameter parameter;
            RelDataType argumentType = argumentTypes.get(i);
            if (Schemas.canConvert(argumentType, (parameter = parameters.get(i)).getType(typeFactory))) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvert(RelDataType fromType, RelDataType toType) {
        return SqlTypeUtil.canAssignFrom(toType, fromType);
    }

    public static Expression expression(SchemaPlus schema) {
        return schema.getExpression(schema.getParentSchema(), schema.getName());
    }

    public static Expression subSchemaExpression(SchemaPlus schema, String name, Class type) {
        Expression schemaExpression = Schemas.expression(schema);
        MethodCallExpression call = Expressions.call(schemaExpression, BuiltInMethod.SCHEMA_GET_SUB_SCHEMA.method, Expressions.constant(name));
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_(Expressions.call(call, BuiltInMethod.SCHEMA_PLUS_UNWRAP.method, Expressions.constant(type)), type);
    }

    public static Expression tableExpression(SchemaPlus schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression;
        if (Table.class.isAssignableFrom(clazz)) {
            expression = Expressions.call(Schemas.expression(schema), BuiltInMethod.SCHEMA_GET_TABLE.method, Expressions.constant(tableName));
            if (ScannableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call(BuiltInMethod.SCHEMAS_ENUMERABLE_SCANNABLE.method, Expressions.convert_(expression, ScannableTable.class), DataContext.ROOT);
            }
            if (FilterableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call(BuiltInMethod.SCHEMAS_ENUMERABLE_FILTERABLE.method, Expressions.convert_(expression, FilterableTable.class), DataContext.ROOT);
            }
            if (ProjectableFilterableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call(BuiltInMethod.SCHEMAS_ENUMERABLE_PROJECTABLE_FILTERABLE.method, Expressions.convert_(expression, ProjectableFilterableTable.class), DataContext.ROOT);
            }
        } else {
            expression = Expressions.call(BuiltInMethod.SCHEMAS_QUERYABLE.method, DataContext.ROOT, Schemas.expression(schema), Expressions.constant(elementType), Expressions.constant(tableName));
        }
        return Types.castIfNecessary(clazz, expression);
    }

    public static DataContext createDataContext(Connection connection, SchemaPlus rootSchema) {
        return new DummyDataContext((CalciteConnection)connection, rootSchema);
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, String ... names) {
        return Schemas.queryable(root, clazz, Arrays.asList(names));
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, Iterable<? extends String> names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        Iterator<? extends String> iterator = names.iterator();
        while (true) {
            name = iterator.next();
            if (!iterator.hasNext()) break;
            schema = schema.getSubSchema(name);
        }
        return Schemas.queryable(root, schema, clazz, name);
    }

    public static <E> Queryable<E> queryable(DataContext root, SchemaPlus schema, Class<E> clazz, String tableName) {
        QueryableTable table = (QueryableTable)schema.getTable(tableName);
        return table.asQueryable(root.getQueryProvider(), schema, tableName);
    }

    public static Enumerable<Object[]> enumerable(ScannableTable table, DataContext root) {
        return table.scan(root);
    }

    public static Enumerable<Object[]> enumerable(FilterableTable table, DataContext root) {
        return table.scan(root, ImmutableList.of());
    }

    public static Enumerable<Object[]> enumerable(ProjectableFilterableTable table, DataContext root) {
        return table.scan(root, ImmutableList.of(), Schemas.identity(table.getRowType(root.getTypeFactory()).getFieldCount()));
    }

    private static int[] identity(int count) {
        int[] integers = new int[count];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public static Table table(DataContext root, String ... names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        List<String> nameList = Arrays.asList(names);
        Iterator<String> iterator = nameList.iterator();
        while (true) {
            name = iterator.next();
            if (!iterator.hasNext()) break;
            schema = schema.getSubSchema(name);
        }
        return schema.getTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.ParseResult parse(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, String sql) {
        CalcitePrepare prepare = CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap<CalciteConnectionProperty, String> propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.ConvertResult convert(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, String sql) {
        CalcitePrepare prepare = CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap<CalciteConnectionProperty, String> propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.ConvertResult convertResult = prepare.convert(context, sql);
            return convertResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.AnalyzeViewResult analyzeView(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, String viewSql, List<String> viewPath, boolean fail) {
        CalcitePrepare prepare = CalcitePrepare.DEFAULT_FACTORY.apply();
        ImmutableMap<CalciteConnectionProperty, String> propValues = ImmutableMap.of();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, viewPath, propValues);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.AnalyzeViewResult analyzeViewResult = prepare.analyzeView(context, viewSql, fail);
            return analyzeViewResult;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalcitePrepare.CalciteSignature<Object> prepare(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, String sql, ImmutableMap<CalciteConnectionProperty, String> map) {
        CalcitePrepare prepare = CalcitePrepare.DEFAULT_FACTORY.apply();
        CalcitePrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, null, map);
        CalcitePrepare.Dummy.push(context);
        try {
            CalcitePrepare.CalciteSignature<Object> calciteSignature = prepare.prepareSql(context, CalcitePrepare.Query.of(sql), (Type)((Object)Object[].class), -1L);
            return calciteSignature;
        }
        finally {
            CalcitePrepare.Dummy.pop(context);
        }
    }

    private static CalcitePrepare.Context makeContext(CalciteConnection connection, CalciteSchema schema, List<String> schemaPath, List<String> objectPath, ImmutableMap<CalciteConnectionProperty, String> propValues) {
        if (connection == null) {
            CalcitePrepare.Context context0 = CalcitePrepare.Dummy.peek();
            CalciteConnectionConfig config = Schemas.mutate(context0.config(), propValues);
            return Schemas.makeContext(config, context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath, objectPath);
        }
        CalciteConnectionConfig config = Schemas.mutate(connection.config(), propValues);
        return Schemas.makeContext(config, connection.getTypeFactory(), Schemas.createDataContext(connection, schema.root().plus()), schema, schemaPath, objectPath);
    }

    private static CalciteConnectionConfig mutate(CalciteConnectionConfig config, ImmutableMap<CalciteConnectionProperty, String> propValues) {
        for (Map.Entry e : propValues.entrySet()) {
            config = ((CalciteConnectionConfigImpl)config).set((CalciteConnectionProperty)e.getKey(), (String)e.getValue());
        }
        return config;
    }

    private static CalcitePrepare.Context makeContext(final CalciteConnectionConfig connectionConfig, final JavaTypeFactory typeFactory, final DataContext dataContext, final CalciteSchema schema, final List<String> schemaPath, List<String> objectPath_) {
        final ImmutableList<String> objectPath = objectPath_ == null ? null : ImmutableList.copyOf(objectPath_);
        return new CalcitePrepare.Context(){

            @Override
            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            @Override
            public CalciteSchema getRootSchema() {
                return schema.root();
            }

            @Override
            public CalciteSchema getMutableRootSchema() {
                return this.getRootSchema();
            }

            @Override
            public List<String> getDefaultSchemaPath() {
                if (schemaPath == null) {
                    return schema.path(null);
                }
                return schemaPath;
            }

            @Override
            public List<String> getObjectPath() {
                return objectPath;
            }

            @Override
            public CalciteConnectionConfig config() {
                return connectionConfig;
            }

            @Override
            public DataContext getDataContext() {
                return dataContext;
            }

            @Override
            public RelRunner getRelRunner() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CalcitePrepare.SparkHandler spark() {
                boolean enable = this.config().spark();
                return CalcitePrepare.Dummy.getSparkHandler(enable);
            }
        };
    }

    public static RelProtoDataType proto(final Table table) {
        return new RelProtoDataType(){

            @Override
            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return table.getRowType(typeFactory);
            }
        };
    }

    public static RelProtoDataType proto(final ScalarFunction function) {
        return new RelProtoDataType(){

            @Override
            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return function.getReturnType(typeFactory);
            }
        };
    }

    public static List<CalciteSchema.TableEntry> getStarTables(CalciteSchema schema) {
        List<CalciteSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Lists.transform(list, TO_TABLE_ENTRY);
    }

    public static List<Lattice> getLattices(CalciteSchema schema) {
        List<CalciteSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Lists.transform(list, TO_LATTICE);
    }

    public static List<CalciteSchema.LatticeEntry> getLatticeEntries(CalciteSchema schema) {
        ArrayList<CalciteSchema.LatticeEntry> list = Lists.newArrayList();
        Schemas.gatherLattices(schema, list);
        return list;
    }

    private static void gatherLattices(CalciteSchema schema, List<CalciteSchema.LatticeEntry> list) {
        list.addAll(schema.getLatticeMap().values());
        for (CalciteSchema subSchema : schema.getSubSchemaMap().values()) {
            Schemas.gatherLattices(subSchema, list);
        }
    }

    public static CalciteSchema subSchema(CalciteSchema schema, Iterable<String> names) {
        for (String string : names) {
            if (schema == null) {
                return null;
            }
            schema = schema.getSubSchema(string, false);
        }
        return schema;
    }

    public static String uniqueTableName(CalciteSchema schema, String base) {
        String t = Preconditions.checkNotNull(base);
        int x = 0;
        while (schema.getTable(t, true) != null) {
            t = base + x;
            ++x;
        }
        return t;
    }

    public static Path path(CalciteSchema rootSchema, Iterable<String> names) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Schema schema = rootSchema.plus();
        Iterator<String> iterator = names.iterator();
        if (!iterator.hasNext()) {
            return PathImpl.EMPTY;
        }
        if (!rootSchema.name.isEmpty()) assert (rootSchema.name.equals(iterator.next()));
        while (true) {
            String name = iterator.next();
            builder.add(Pair.of(name, schema));
            if (!iterator.hasNext()) {
                return Schemas.path((ImmutableList<Pair<String, Schema>>)builder.build());
            }
            schema = schema.getSubSchema(name);
        }
    }

    public static PathImpl path(ImmutableList<Pair<String, Schema>> build) {
        return new PathImpl(build);
    }

    public static Path path(SchemaPlus schema) {
        ArrayList<Pair<String, SchemaPlus>> list = new ArrayList<Pair<String, SchemaPlus>>();
        for (SchemaPlus s = schema; s != null; s = s.getParentSchema()) {
            list.add(Pair.of(s.getName(), s));
        }
        return new PathImpl(ImmutableList.copyOf(Lists.reverse(list)));
    }

    private static class PathImpl
    extends AbstractList<Pair<String, Schema>>
    implements Path {
        private final ImmutableList<Pair<String, Schema>> pairs;
        private static final PathImpl EMPTY = new PathImpl(ImmutableList.of());

        PathImpl(ImmutableList<Pair<String, Schema>> pairs) {
            this.pairs = pairs;
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o instanceof PathImpl && this.pairs.equals(((PathImpl)o).pairs);
        }

        @Override
        public int hashCode() {
            return this.pairs.hashCode();
        }

        @Override
        public Pair<String, Schema> get(int index) {
            return (Pair)this.pairs.get(index);
        }

        @Override
        public int size() {
            return this.pairs.size();
        }

        @Override
        public Path parent() {
            if (this.pairs.isEmpty()) {
                throw new IllegalArgumentException("at root");
            }
            return new PathImpl((ImmutableList<Pair<String, Schema>>)this.pairs.subList(0, this.pairs.size() - 1));
        }

        @Override
        public List<String> names() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return (String)((Pair)((PathImpl)PathImpl.this).pairs.get((int)(index + 1))).left;
                }

                @Override
                public int size() {
                    return PathImpl.this.pairs.size() - 1;
                }
            };
        }

        @Override
        public List<Schema> schemas() {
            return Pair.right(this.pairs);
        }
    }

    private static class DummyDataContext
    implements DataContext {
        private final CalciteConnection connection;
        private final SchemaPlus rootSchema;
        private final ImmutableMap<String, Object> map;

        DummyDataContext(CalciteConnection connection, SchemaPlus rootSchema) {
            this.connection = connection;
            this.rootSchema = rootSchema;
            this.map = ImmutableMap.of();
        }

        @Override
        public SchemaPlus getRootSchema() {
            return this.rootSchema;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.connection.getTypeFactory();
        }

        @Override
        public QueryProvider getQueryProvider() {
            return this.connection;
        }

        @Override
        public Object get(String name) {
            return this.map.get(name);
        }
    }
}

