/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Function;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.Lists;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlAbstractStringLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeName;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BitString;
import java.util.List;

public class SqlBinaryStringLiteral
extends SqlAbstractStringLiteral {
    private static final Function<SqlLiteral, BitString> F = new Function<SqlLiteral, BitString>(){

        @Override
        public BitString apply(SqlLiteral literal) {
            return ((SqlBinaryStringLiteral)literal).getBitString();
        }
    };

    protected SqlBinaryStringLiteral(BitString val, SqlParserPos pos) {
        super(val, SqlTypeName.BINARY, pos);
    }

    public BitString getBitString() {
        return (BitString)this.value;
    }

    @Override
    public SqlBinaryStringLiteral clone(SqlParserPos pos) {
        return new SqlBinaryStringLiteral((BitString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof BitString);
        writer.literal("X'" + ((BitString)this.value).toHexString() + "'");
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlBinaryStringLiteral(BitString.concat(Lists.transform(literals, F)), literals.get(0).getParserPosition());
    }
}

