/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.SchemaPlus;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.impl.AbstractSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCreate;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlExecutableStatement;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDdlNodes;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.List;

public class SqlCreateUser
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final String password;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE USER", SqlKind.CREATE_USER);

    SqlCreateUser(SqlParserPos pos, boolean replace, SqlIdentifier user, String password) {
        super(OPERATOR, pos, replace, false);
        this.name = Preconditions.checkNotNull(user);
        this.password = Preconditions.checkNotNull(password);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name);
    }

    public String getUserName() {
        return this.name.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("USER");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        SchemaPlus subSchema0 = ((CalciteSchema)pair.left).plus().getSubSchema((String)pair.right);
        if (subSchema0 != null && !this.getReplace() && !this.ifNotExists) {
            throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.schemaExists((String)pair.right));
        }
        AbstractSchema subSchema = new AbstractSchema();
        ((CalciteSchema)pair.left).add((String)pair.right, subSchema);
    }
}

