/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSpecialOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;

public class SqlKeyConstraint
extends SqlCall {
    private static final SqlSpecialOperator UNIQUE = new SqlSpecialOperator("UNIQUE", SqlKind.UNIQUE);
    protected static final SqlSpecialOperator PRIMARY = new SqlSpecialOperator("PRIMARY KEY", SqlKind.PRIMARY_KEY);
    private final SqlIdentifier name;
    private final SqlNodeList columnList;

    SqlKeyConstraint(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        super(pos);
        this.name = name;
        this.columnList = columnList;
    }

    public static SqlKeyConstraint unique(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList);
    }

    public static SqlKeyConstraint primary(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList){

            @Override
            public SqlOperator getOperator() {
                return PRIMARY;
            }
        };
    }

    @Override
    public SqlOperator getOperator() {
        return UNIQUE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.columnList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.name != null) {
            writer.keyword("CONSTRAINT");
            this.name.unparse(writer, 0, 0);
        }
        writer.keyword(this.getOperator().getName());
        this.columnList.unparse(writer, 1, 1);
    }
}

