/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCallBinding;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperandCountRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSelect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.validate.SqlValidator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Static;
import java.util.AbstractList;
import java.util.List;

public class SetopOperandTypeChecker
implements SqlOperandTypeChecker {
    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int i;
        assert (callBinding.getOperandCount() == 2) : "setops are binary (for now)";
        final RelDataType[] argTypes = new RelDataType[callBinding.getOperandCount()];
        int colCount = -1;
        SqlValidator validator = callBinding.getValidator();
        for (i = 0; i < argTypes.length; ++i) {
            argTypes[i] = callBinding.getOperandType(i);
            RelDataType argType = argTypes[i];
            if (!argType.isStruct()) {
                if (throwOnFailure) {
                    throw new AssertionError((Object)"setop arg must be a struct");
                }
                return false;
            }
            List<RelDataTypeField> fields = argType.getFieldList();
            if (i == 0) {
                colCount = fields.size();
                continue;
            }
            if (fields.size() == colCount) continue;
            if (throwOnFailure) {
                SqlNode node = callBinding.operand(i);
                if (node instanceof SqlSelect) {
                    node = ((SqlSelect)node).getSelectList();
                }
                throw validator.newValidationError(node, Static.RESOURCE.columnCountMismatchInSetop(callBinding.getOperator().getName()));
            }
            return false;
        }
        i = 0;
        while (i < colCount) {
            final int i2 = i++;
            RelDataType type = callBinding.getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return argTypes[index].getFieldList().get(i2).getType();
                }

                @Override
                public int size() {
                    return argTypes.length;
                }
            });
            if (type != null) continue;
            if (throwOnFailure) {
                SqlNode field = SqlUtil.getSelectListItem(callBinding.operand(0), i);
                throw validator.newValidationError(field, Static.RESOURCE.columnTypeMismatchInSetop(i + 1, callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "{0} " + opName + " {1}";
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

