/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler;

import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.ICompilerFactory;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public final class CompilerFactoryFactory {
    private static ICompilerFactory defaultCompilerFactory;

    private CompilerFactoryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICompilerFactory getDefaultCompilerFactory() throws Exception {
        if (defaultCompilerFactory == null) {
            Properties properties = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.properties");
            if (is == null) {
                throw new ClassNotFoundException("No implementation of org.codehaus.commons.compiler is on the class path. Typically, you'd have 'janino.jar', or 'commons-compiler-jdk.jar', or both on the classpath.");
            }
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
            String compilerFactoryClassName = properties.getProperty("compilerFactory");
            defaultCompilerFactory = CompilerFactoryFactory.getCompilerFactory(compilerFactoryClassName);
        }
        return defaultCompilerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICompilerFactory[] getAllCompilerFactories() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<ICompilerFactory> factories = new ArrayList<ICompilerFactory>();
        Enumeration<URL> en = cl.getResources("com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.properties");
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
            String compilerFactoryClassName = properties.getProperty("compilerFactory");
            if (compilerFactoryClassName == null) {
                throw new IllegalStateException(url.toString() + " does not specify the 'compilerFactory' property");
            }
            factories.add(CompilerFactoryFactory.getCompilerFactory(compilerFactoryClassName));
        }
        return factories.toArray(new ICompilerFactory[factories.size()]);
    }

    public static ICompilerFactory getCompilerFactory(String compilerFactoryClassName) throws Exception {
        return (ICompilerFactory)Thread.currentThread().getContextClassLoader().loadClass(compilerFactoryClassName).newInstance();
    }

    public static String getSpecificationVersion() {
        return CompilerFactoryFactory.class.getPackage().getSpecificationVersion();
    }
}

