/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.codehaus.janino;

import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Descriptor;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.IClass;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.JaninoRuntimeException;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Java;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Opcode;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeContext {
    private static final boolean DEBUG = false;
    private static final int INITIAL_SIZE = 128;
    private static final byte UNEXAMINED = -1;
    private static final byte INVALID_OFFSET = -2;
    private static final int MAX_STACK_SIZE = 254;
    private final ClassFile classFile;
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private final Offset beginning;
    private final Inserter end;
    private Inserter currentInserter;
    private final List<ExceptionTableEntry> exceptionTableEntries;
    private final List<Java.LocalVariableSlot> allLocalVars = new ArrayList<Java.LocalVariableSlot>();
    private final List<List<Java.LocalVariableSlot>> scopedVars = new ArrayList<List<Java.LocalVariableSlot>>();
    private short nextLocalVariableSlot;
    private final List<Relocatable> relocatables = new ArrayList<Relocatable>();
    private static final Map<Byte, Byte> BRANCH_OPCODE_INVERSION = CodeContext.createBranchOpcodeInversion();

    public CodeContext(ClassFile classFile) {
        this.classFile = classFile;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.code = new byte[128];
        this.beginning = new Offset();
        this.currentInserter = this.end = new Inserter();
        this.exceptionTableEntries = new ArrayList<ExceptionTableEntry>();
        this.beginning.offset = 0;
        this.end.offset = 0;
        this.beginning.next = this.end;
        this.end.prev = this.beginning;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short allocateLocalVariable(short size) {
        return this.allocateLocalVariable(size, null, null).getSlotIndex();
    }

    public Java.LocalVariableSlot allocateLocalVariable(short size, String name, IClass type) {
        List<Java.LocalVariableSlot> currentVars = null;
        if (this.scopedVars.size() == 0) {
            throw new Error("saveLocalVariables must be called first");
        }
        currentVars = this.scopedVars.get(this.scopedVars.size() - 1);
        Java.LocalVariableSlot slot = new Java.LocalVariableSlot(name, this.nextLocalVariableSlot, type);
        if (slot.getName() != null) {
            slot.setStart(this.newOffset());
        }
        this.nextLocalVariableSlot = (short)(this.nextLocalVariableSlot + size);
        currentVars.add(slot);
        this.allLocalVars.add(slot);
        if (this.nextLocalVariableSlot > this.maxLocals) {
            this.maxLocals = this.nextLocalVariableSlot;
        }
        return slot;
    }

    public List<Java.LocalVariableSlot> saveLocalVariables() {
        ArrayList<Java.LocalVariableSlot> l = new ArrayList<Java.LocalVariableSlot>();
        this.scopedVars.add(l);
        return l;
    }

    public void restoreLocalVariables() {
        List<Java.LocalVariableSlot> slots = this.scopedVars.remove(this.scopedVars.size() - 1);
        for (Java.LocalVariableSlot slot : slots) {
            if (slot.getName() == null) continue;
            slot.setEnd(this.newOffset());
        }
    }

    protected void storeCodeAttributeBody(DataOutputStream dos, short lineNumberTableAttributeNameIndex, short localVariableTableAttributeNameIndex) throws IOException {
        ClassFile.AttributeInfo ai;
        dos.writeShort(this.maxStack);
        dos.writeShort(this.maxLocals);
        dos.writeInt(this.end.offset);
        dos.write(this.code, 0, this.end.offset);
        dos.writeShort(this.exceptionTableEntries.size());
        for (ExceptionTableEntry exceptionTableEntry : this.exceptionTableEntries) {
            dos.writeShort(exceptionTableEntry.startPC.offset);
            dos.writeShort(exceptionTableEntry.endPC.offset);
            dos.writeShort(exceptionTableEntry.handlerPC.offset);
            dos.writeShort(exceptionTableEntry.catchType);
        }
        ArrayList<ClassFile.AttributeInfo> attributes = new ArrayList<ClassFile.AttributeInfo>();
        if (lineNumberTableAttributeNameIndex != 0) {
            ArrayList<ClassFile.LineNumberTableAttribute.Entry> lnt = new ArrayList<ClassFile.LineNumberTableAttribute.Entry>();
            Offset o = this.beginning;
            while (o != null) {
                if (o instanceof LineNumberOffset) {
                    lnt.add(new ClassFile.LineNumberTableAttribute.Entry(o.offset, ((LineNumberOffset)o).lineNumber));
                }
                o = o.next;
            }
            ClassFile.LineNumberTableAttribute.Entry[] lnte = lnt.toArray(new ClassFile.LineNumberTableAttribute.Entry[lnt.size()]);
            attributes.add(new ClassFile.LineNumberTableAttribute(lineNumberTableAttributeNameIndex, lnte));
        }
        if (localVariableTableAttributeNameIndex != 0 && (ai = this.storeLocalVariableTable(dos, localVariableTableAttributeNameIndex)) != null) {
            attributes.add(ai);
        }
        dos.writeShort(attributes.size());
        for (ClassFile.AttributeInfo attribute : attributes) {
            attribute.store(dos);
        }
    }

    protected ClassFile.AttributeInfo storeLocalVariableTable(DataOutputStream dos, short localVariableTableAttributeNameIndex) {
        ClassFile cf = this.getClassFile();
        ArrayList<ClassFile.LocalVariableTableAttribute.Entry> entryList = new ArrayList<ClassFile.LocalVariableTableAttribute.Entry>();
        for (Java.LocalVariableSlot slot : this.getAllLocalVars()) {
            if (slot.getName() == null) continue;
            String typeName = slot.getType().getDescriptor();
            short classSlot = cf.addConstantUtf8Info(typeName);
            short varNameSlot = cf.addConstantUtf8Info(slot.getName());
            ClassFile.LocalVariableTableAttribute.Entry entry = new ClassFile.LocalVariableTableAttribute.Entry((short)slot.getStart().offset, (short)(slot.getEnd().offset - slot.getStart().offset), varNameSlot, classSlot, slot.getSlotIndex());
            entryList.add(entry);
        }
        if (entryList.size() > 0) {
            ClassFile.LocalVariableTableAttribute.Entry[] entries = entryList.toArray(new ClassFile.LocalVariableTableAttribute.Entry[entryList.size()]);
            return new ClassFile.LocalVariableTableAttribute(localVariableTableAttributeNameIndex, entries);
        }
        return null;
    }

    public void flowAnalysis(String functionName) {
        short[] stackSizes = new short[this.end.offset];
        Arrays.fill(stackSizes, (short)-1);
        this.flowAnalysis(functionName, this.code, this.end.offset, 0, (short)0, stackSizes);
        int analyzedExceptionHandlers = 0;
        while (analyzedExceptionHandlers != this.exceptionTableEntries.size()) {
            for (ExceptionTableEntry exceptionTableEntry : this.exceptionTableEntries) {
                if (stackSizes[exceptionTableEntry.startPC.offset] == -1) continue;
                this.flowAnalysis(functionName, this.code, this.end.offset, exceptionTableEntry.handlerPC.offset, (short)(stackSizes[exceptionTableEntry.startPC.offset] + 1), stackSizes);
                ++analyzedExceptionHandlers;
            }
        }
        this.maxStack = 0;
        for (int i = 0; i < stackSizes.length; ++i) {
            short ss = stackSizes[i];
            if (ss == -1) {
                throw new JaninoRuntimeException(functionName + ": Unexamined code at offset " + i);
            }
            if (ss <= this.maxStack) continue;
            this.maxStack = ss;
        }
    }

    private void flowAnalysis(String functionName, byte[] code, int codeSize, int offset, short stackSize, short[] stackSizes) {
        while (true) {
            short props;
            if (offset < 0 || offset >= codeSize) {
                throw new JaninoRuntimeException(functionName + ": Offset out of range");
            }
            short css = stackSizes[offset];
            if (css == stackSize) {
                return;
            }
            if (css == -2) {
                throw new JaninoRuntimeException(functionName + ": Invalid offset");
            }
            if (css != -1) {
                throw new JaninoRuntimeException(functionName + ": Operand stack inconsistent at offset " + offset + ": Previous size " + css + ", now " + stackSize);
            }
            stackSizes[offset] = stackSize;
            byte opcode = code[offset];
            int operandOffset = offset + 1;
            if (opcode == -60) {
                opcode = code[operandOffset++];
                props = Opcode.WIDE_OPCODE_PROPERTIES[0xFF & opcode];
            } else {
                props = Opcode.OPCODE_PROPERTIES[0xFF & opcode];
            }
            if (props == -1) {
                throw new JaninoRuntimeException(functionName + ": Invalid opcode " + (0xFF & opcode) + " at offset " + offset);
            }
            switch (props & 0x1F) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    stackSize = (short)(stackSize + ((props & 0x1F) - 4));
                    break;
                }
                case 7: {
                    stackSize = 0;
                    break;
                }
                case 9: {
                    stackSize = (short)(stackSize - 1);
                }
                case 10: {
                    stackSize = (short)(stackSize + this.determineFieldSize((short)CodeContext.extract16BitValue(0, operandOffset, code)));
                    break;
                }
                case 11: {
                    stackSize = (short)(stackSize - 1);
                }
                case 12: {
                    stackSize = (short)(stackSize - this.determineFieldSize((short)CodeContext.extract16BitValue(0, operandOffset, code)));
                    break;
                }
                case 13: 
                case 14: 
                case 16: {
                    stackSize = (short)(stackSize - 1);
                }
                case 15: {
                    stackSize = (short)(stackSize - this.determineArgumentsSize((short)CodeContext.extract16BitValue(0, operandOffset, code)));
                    break;
                }
                case 18: {
                    stackSize = (short)(stackSize - (code[operandOffset + 2] - 1));
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(functionName + ": Invalid stack delta");
                }
            }
            if (stackSize < 0) {
                String msg = this.classFile.getThisClassName() + '.' + functionName + ": Operand stack underrun at offset " + offset;
                throw new JaninoRuntimeException(msg);
            }
            if (stackSize > 254) {
                String msg = this.classFile.getThisClassName() + '.' + functionName + ": Operand stack overflow at offset " + offset;
                throw new JaninoRuntimeException(msg);
            }
            switch (props & 0x1E0) {
                case 0: {
                    break;
                }
                case 32: 
                case 64: 
                case 128: 
                case 192: {
                    ++operandOffset;
                    break;
                }
                case 96: 
                case 160: 
                case 224: {
                    operandOffset += 2;
                    break;
                }
                case 256: {
                    this.flowAnalysis(functionName, code, codeSize, CodeContext.extract16BitValue(offset, operandOffset, code), stackSize, stackSizes);
                    operandOffset += 2;
                    break;
                }
                case 384: {
                    int targetOffset = CodeContext.extract16BitValue(offset, operandOffset, code);
                    operandOffset += 2;
                    if (stackSizes[targetOffset] != -1) break;
                    this.flowAnalysis(functionName, code, codeSize, targetOffset, (short)(stackSize + 1), stackSizes);
                    break;
                }
                case 288: {
                    this.flowAnalysis(functionName, code, codeSize, CodeContext.extract32BitValue(offset, operandOffset, code), stackSize, stackSizes);
                    operandOffset += 4;
                    break;
                }
                case 320: {
                    while ((operandOffset & 3) != 0) {
                        ++operandOffset;
                    }
                    this.flowAnalysis(functionName, code, codeSize, CodeContext.extract32BitValue(offset, operandOffset, code), stackSize, stackSizes);
                    int npairs = CodeContext.extract32BitValue(0, operandOffset += 4, code);
                    operandOffset += 4;
                    for (int i = 0; i < npairs; ++i) {
                        this.flowAnalysis(functionName, code, codeSize, CodeContext.extract32BitValue(offset, operandOffset += 4, code), stackSize, stackSizes);
                        operandOffset += 4;
                    }
                    break;
                }
                case 352: {
                    while ((operandOffset & 3) != 0) {
                        ++operandOffset;
                    }
                    this.flowAnalysis(functionName, code, codeSize, CodeContext.extract32BitValue(offset, operandOffset, code), stackSize, stackSizes);
                    int low = CodeContext.extract32BitValue(offset, operandOffset += 4, code);
                    int hi = CodeContext.extract32BitValue(offset, operandOffset += 4, code);
                    operandOffset += 4;
                    for (int i = low; i <= hi; ++i) {
                        this.flowAnalysis(functionName, code, codeSize, CodeContext.extract32BitValue(offset, operandOffset, code), stackSize, stackSizes);
                        operandOffset += 4;
                    }
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(functionName + ": Invalid OP1");
                }
            }
            switch (props & 0x600) {
                case 0: {
                    break;
                }
                case 512: {
                    ++operandOffset;
                    break;
                }
                case 1024: {
                    operandOffset += 2;
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(functionName + ": Invalid OP2");
                }
            }
            switch (props & 0x800) {
                case 0: {
                    break;
                }
                case 2048: {
                    ++operandOffset;
                    break;
                }
                default: {
                    throw new JaninoRuntimeException(functionName + ": Invalid OP3");
                }
            }
            Arrays.fill(stackSizes, offset + 1, operandOffset, (short)-2);
            if ((props & Short.MIN_VALUE) != 0) {
                return;
            }
            offset = operandOffset;
        }
    }

    private static int extract16BitValue(int bias, int offset, byte[] code) {
        int res = bias + ((code[offset] << 8) + (code[offset + 1] & 0xFF));
        return res;
    }

    private static int extract32BitValue(int bias, int offset, byte[] code) {
        int res = bias + ((code[offset] << 24) + ((0xFF & code[offset + 1]) << 16) + ((0xFF & code[offset + 2]) << 8) + (0xFF & code[offset + 3]));
        return res;
    }

    public void fixUpAndRelocate() {
        do {
            this.fixUp();
        } while (!this.relocate());
    }

    private void fixUp() {
        Offset o = this.beginning;
        while (o != this.end) {
            if (o instanceof FixUp) {
                ((FixUp)((Object)o)).fixUp();
            }
            o = o.next;
        }
    }

    private boolean relocate() {
        boolean finished = true;
        for (Relocatable relocatable : this.relocatables) {
            finished &= relocatable.relocate();
        }
        return finished;
    }

    private int determineFieldSize(short idx) {
        ClassFile.ConstantFieldrefInfo cfi = (ClassFile.ConstantFieldrefInfo)this.classFile.getConstantPoolInfo(idx);
        return Descriptor.size(cfi.getNameAndType(this.classFile).getDescriptor(this.classFile));
    }

    /*
     * Unable to fully structure code
     */
    private int determineArgumentsSize(short idx) {
        cpi = this.classFile.getConstantPoolInfo(idx);
        nat = cpi instanceof ClassFile.ConstantInterfaceMethodrefInfo != false ? ((ClassFile.ConstantInterfaceMethodrefInfo)cpi).getNameAndType(this.classFile) : ((ClassFile.ConstantMethodrefInfo)cpi).getNameAndType(this.classFile);
        desc = nat.getDescriptor(this.classFile);
        if (desc.charAt(0) != '(') {
            throw new JaninoRuntimeException("Method descriptor does not start with \"(\"");
        }
        i = 1;
        res = 0;
        block7: while (true) {
            switch (desc.charAt(i++)) {
                case ')': {
                    return res - Descriptor.size(desc.substring(i));
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++res;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    res += 2;
                    continue block7;
                }
                case '[': {
                    ++res;
                    while (desc.charAt(i) == '[') {
                        ++i;
                    }
                    if ("BCFISZDJ".indexOf(desc.charAt(i)) != -1) {
                        ++i;
                        continue block7;
                    }
                    if (desc.charAt(i) != 'L') {
                        throw new JaninoRuntimeException("Invalid char after \"[\"");
                    }
                    while (true) {
                        v0 = ++i;
                        ++i;
                        if (desc.charAt(v0) == ';') continue block7;
                    }
                }
                case 'L': {
                    ++res;
                    while (true) {
                        if (desc.charAt(i++) != ';') ** break;
                        continue block7;
                    }
                }
            }
            break;
        }
        throw new JaninoRuntimeException("Invalid method descriptor");
    }

    public void write(short lineNumber, byte[] b) {
        if (b.length == 0) {
            return;
        }
        int ico = this.currentInserter.offset;
        this.makeSpace(lineNumber, b.length);
        System.arraycopy(b, 0, this.code, ico, b.length);
    }

    public void write(short lineNumber, byte b1) {
        int ico = this.currentInserter.offset;
        this.makeSpace(lineNumber, 1);
        this.code[ico] = b1;
    }

    public void write(short lineNumber, byte b1, byte b2) {
        int ico = this.currentInserter.offset;
        this.makeSpace(lineNumber, 2);
        this.code[ico++] = b1;
        this.code[ico] = b2;
    }

    public void write(short lineNumber, byte b1, byte b2, byte b3) {
        int ico = this.currentInserter.offset;
        this.makeSpace(lineNumber, 3);
        this.code[ico++] = b1;
        this.code[ico++] = b2;
        this.code[ico] = b3;
    }

    public void write(short lineNumber, byte b1, byte b2, byte b3, byte b4) {
        int ico = this.currentInserter.offset;
        this.makeSpace(lineNumber, 4);
        this.code[ico++] = b1;
        this.code[ico++] = b2;
        this.code[ico++] = b3;
        this.code[ico] = b4;
    }

    public void makeSpace(short lineNumber, int size) {
        block9: {
            if (size == 0) {
                return;
            }
            if (lineNumber != -1) {
                Offset o = this.currentInserter.prev;
                while (o != this.beginning) {
                    if (o instanceof LineNumberOffset) {
                        if (((LineNumberOffset)o).lineNumber != lineNumber) break;
                        break block9;
                    }
                    o = o.prev;
                }
                LineNumberOffset lno = new LineNumberOffset(this.currentInserter.offset, lineNumber);
                lno.prev = this.currentInserter.prev;
                lno.next = this.currentInserter;
                this.currentInserter.prev.next = lno;
                this.currentInserter.prev = lno;
            }
        }
        int ico = this.currentInserter.offset;
        if (this.end.offset + size <= this.code.length) {
            if (ico != this.end.offset) {
                System.arraycopy(this.code, ico, this.code, ico + size, this.end.offset - ico);
            }
        } else {
            byte[] oldCode = this.code;
            int newSize = Math.max(Math.min(oldCode.length * 2, 65535), oldCode.length + size);
            if (newSize > 65535) {
                throw new JaninoRuntimeException("Code attribute in class \"" + this.classFile.getThisClassName() + "\" grows beyond 64 KB");
            }
            this.code = new byte[newSize];
            System.arraycopy(oldCode, 0, this.code, 0, ico);
            System.arraycopy(oldCode, ico, this.code, ico + size, this.end.offset - ico);
        }
        Arrays.fill(this.code, ico, ico + size, (byte)0);
        Offset o = this.currentInserter;
        while (o != null) {
            o.offset += size;
            o = o.next;
        }
    }

    public void writeShort(short lineNumber, int v) {
        this.write(lineNumber, (byte)(v >> 8), (byte)v);
    }

    public void writeBranch(short lineNumber, int opcode, Offset dst) {
        this.relocatables.add(new Branch(opcode, dst));
        this.write(lineNumber, (byte)opcode, (byte)-1, (byte)-1);
    }

    private static byte invertBranchOpcode(byte branchOpcode) {
        return BRANCH_OPCODE_INVERSION.get(new Byte(branchOpcode));
    }

    private static Map<Byte, Byte> createBranchOpcodeInversion() {
        HashMap<Byte, Byte> m = new HashMap<Byte, Byte>();
        m.put(new Byte(-91), new Byte(-90));
        m.put(new Byte(-90), new Byte(-91));
        m.put(new Byte(-97), new Byte(-96));
        m.put(new Byte(-96), new Byte(-97));
        m.put(new Byte(-94), new Byte(-95));
        m.put(new Byte(-95), new Byte(-94));
        m.put(new Byte(-93), new Byte(-92));
        m.put(new Byte(-92), new Byte(-93));
        m.put(new Byte(-103), new Byte(-102));
        m.put(new Byte(-102), new Byte(-103));
        m.put(new Byte(-100), new Byte(-101));
        m.put(new Byte(-101), new Byte(-100));
        m.put(new Byte(-99), new Byte(-98));
        m.put(new Byte(-98), new Byte(-99));
        m.put(new Byte(-58), new Byte(-57));
        m.put(new Byte(-57), new Byte(-58));
        return Collections.unmodifiableMap(m);
    }

    public void writeOffset(short lineNumber, Offset src, Offset dst) {
        this.relocatables.add(new OffsetBranch(this.newOffset(), src, dst));
        this.write(lineNumber, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
    }

    public Offset newOffset() {
        Offset o = new Offset();
        o.set();
        return o;
    }

    public Inserter newInserter() {
        Inserter i = new Inserter();
        i.set();
        return i;
    }

    public Inserter currentInserter() {
        return this.currentInserter;
    }

    public void pushInserter(Inserter ins) {
        if (ins.nextInserter != null) {
            throw new JaninoRuntimeException("An Inserter can only be pushed once at a time");
        }
        ins.nextInserter = this.currentInserter;
        this.currentInserter = ins;
    }

    public void popInserter() {
        Inserter ni = this.currentInserter.nextInserter;
        if (ni == null) {
            throw new JaninoRuntimeException("Code inserter stack underflow");
        }
        this.currentInserter.nextInserter = null;
        this.currentInserter = ni;
    }

    public void addExceptionTableEntry(Offset startPc, Offset endPc, Offset handlerPc, String catchTypeFd) {
        this.exceptionTableEntries.add(new ExceptionTableEntry(startPc, endPc, handlerPc, catchTypeFd == null ? (short)0 : this.classFile.addConstantClassInfo(catchTypeFd)));
    }

    public List<Java.LocalVariableSlot> getAllLocalVars() {
        return this.allLocalVars;
    }

    public static interface FixUp {
        public void fixUp();
    }

    private abstract class Relocatable {
        private Relocatable() {
        }

        public abstract boolean relocate();
    }

    public class LineNumberOffset
    extends Offset {
        private final int lineNumber;

        public LineNumberOffset(int offset, int lineNumber) {
            this.lineNumber = lineNumber;
            this.offset = offset;
        }
    }

    public class Inserter
    extends Offset {
        private Inserter nextInserter;
    }

    private static class ExceptionTableEntry {
        final Offset startPC;
        final Offset endPC;
        final Offset handlerPC;
        final short catchType;

        ExceptionTableEntry(Offset startPc, Offset endPc, Offset handlerPc, short catchType) {
            this.startPC = startPc;
            this.endPC = endPc;
            this.handlerPC = handlerPc;
            this.catchType = catchType;
        }
    }

    public class Offset {
        int offset = -1;
        Offset prev;
        Offset next;
        static final int UNSET = -1;

        public void set() {
            if (this.offset != -1) {
                throw new JaninoRuntimeException("Cannot \"set()\" Offset more than once");
            }
            this.offset = ((CodeContext)CodeContext.this).currentInserter.offset;
            this.prev = ((CodeContext)CodeContext.this).currentInserter.prev;
            this.next = CodeContext.this.currentInserter;
            this.prev.next = this;
            this.next.prev = this;
        }

        public final CodeContext getCodeContext() {
            return CodeContext.this;
        }

        public String toString() {
            return CodeContext.this.classFile.getThisClassName() + ": " + this.offset;
        }
    }

    private class OffsetBranch
    extends Relocatable {
        private final Offset where;
        private final Offset source;
        private final Offset destination;

        public OffsetBranch(Offset where, Offset source, Offset destination) {
            this.where = where;
            this.source = source;
            this.destination = destination;
        }

        @Override
        public boolean relocate() {
            if (this.source.offset == -1 || this.destination.offset == -1) {
                throw new JaninoRuntimeException("Cannot relocate offset branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            byte[] ba = new byte[]{(byte)(offset >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset};
            System.arraycopy(ba, 0, CodeContext.this.code, this.where.offset, 4);
            return true;
        }
    }

    private class Branch
    extends Relocatable {
        private boolean expanded;
        private final int opcode;
        private final Inserter source;
        private final Offset destination;

        public Branch(int opcode, Offset destination) {
            this.opcode = opcode;
            this.source = CodeContext.this.newInserter();
            this.destination = destination;
            this.expanded = opcode == -55 || opcode == -56;
        }

        @Override
        public boolean relocate() {
            if (this.destination.offset == -1) {
                throw new JaninoRuntimeException("Cannot relocate branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            if (!(this.expanded || offset <= Short.MAX_VALUE && offset >= Short.MIN_VALUE)) {
                int pos = this.source.offset;
                CodeContext.this.pushInserter(this.source);
                CodeContext.this.makeSpace((short)-1, this.opcode == -89 ? 2 : (this.opcode == -88 ? 2 : 5));
                CodeContext.this.popInserter();
                this.source.offset = pos;
                this.expanded = true;
                return false;
            }
            byte[] ba = !this.expanded ? new byte[]{(byte)this.opcode, (byte)(offset >> 8), (byte)offset} : (this.opcode == -89 || this.opcode == -88 ? new byte[]{(byte)(this.opcode + 33), (byte)(offset >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset} : new byte[]{CodeContext.invertBranchOpcode((byte)this.opcode), 0, 8, -56, (byte)((offset -= 3) >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset});
            System.arraycopy(ba, 0, CodeContext.this.code, this.source.offset, ba.length);
            return true;
        }
    }
}

