/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.codehaus.janino;

import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.CompileException;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.ErrorHandler;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.Location;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.WarningHandler;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Descriptor;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.IClass;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.IClassLoader;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Java;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Parser;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Scanner;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.UnitCompiler;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.ClassFile;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource.Resource;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.resource.ResourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class JavaSourceIClassLoader
extends IClassLoader {
    private static final boolean DEBUG = false;
    private ResourceFinder sourceFinder;
    private String optionalCharacterEncoding;
    private final Set<UnitCompiler> unitCompilers = new HashSet<UnitCompiler>();
    private ErrorHandler optionalCompileErrorHandler;
    private WarningHandler optionalWarningHandler;

    public JavaSourceIClassLoader(ResourceFinder sourceFinder, String optionalCharacterEncoding, IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.sourceFinder = sourceFinder;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        super.postConstruct();
    }

    public Set<UnitCompiler> getUnitCompilers() {
        return this.unitCompilers;
    }

    public void setSourceFinder(ResourceFinder pathResourceFinder) {
        this.sourceFinder = pathResourceFinder;
    }

    public void setCharacterEncoding(String optionalCharacterEncoding) {
        this.optionalCharacterEncoding = optionalCharacterEncoding;
    }

    public void setCompileErrorHandler(ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    @Override
    public IClass findIClass(String fieldDescriptor) throws ClassNotFoundException {
        IClass res;
        String className = Descriptor.toClassName(fieldDescriptor);
        if (className.startsWith("java.")) {
            return null;
        }
        int idx = className.indexOf(36);
        String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
        for (UnitCompiler uc : this.unitCompilers) {
            res = uc.findClass(topLevelClassName);
            if (res == null) continue;
            if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        try {
            UnitCompiler uc;
            Java.CompilationUnit cu = this.findCompilationUnit(className);
            if (cu == null) {
                return null;
            }
            uc = new UnitCompiler(cu, this);
            uc.setCompileErrorHandler(this.optionalCompileErrorHandler);
            uc.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(uc);
            res = uc.findClass(className);
            if (res == null) {
                if (className.equals(topLevelClassName)) {
                    throw new CompileException("Compilation unit '" + className + "' does not declare a class with the same name", (Location)null);
                }
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Parsing compilation unit '" + className + "'", e);
        }
        catch (CompileException e) {
            throw new ClassNotFoundException("Parsing compilation unit '" + className + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Java.CompilationUnit findCompilationUnit(String className) throws IOException, CompileException {
        Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
        if (sourceResource == null) {
            return null;
        }
        InputStream inputStream = sourceResource.open();
        try {
            Scanner scanner = new Scanner(sourceResource.getFileName(), inputStream, this.optionalCharacterEncoding);
            scanner.setWarningHandler(this.optionalWarningHandler);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.optionalWarningHandler);
            Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
            return compilationUnit;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {}
        }
    }
}

