/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.util;

import com.alibaba.nls.client.util.Base64Encoder;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signer {
    private static final String ALGORITHM_NAME = "HmacSHA1";
    private static final String ENCODING = "UTF-8";
    private static final String GMT = "GMT";

    public static String signString(String stringToSign, String accessKeySecret) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM_NAME);
            mac.init(new SecretKeySpec(accessKeySecret.getBytes(ENCODING), ALGORITHM_NAME));
            byte[] signData = mac.doFinal(stringToSign.getBytes(ENCODING));
            String encodeToString = Base64Encoder.encode(signData);
            return encodeToString.substring(0, (encodeToString + "\n").length() - 1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String toGMTString() {
        return Signer.toGMTString(new Date());
    }

    private static String toGMTString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.UK);
        df.setTimeZone(new SimpleTimeZone(0, GMT));
        String text = df.format(date);
        if (!text.endsWith(GMT)) {
            text = text.substring(0, text.length() - 6);
        }
        return text;
    }
}

