/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sse;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponseHandler;
import darabonba.core.ResponseBytes;
import darabonba.core.async.AsyncResponseHandler;
import darabonba.core.async.ByteArrayAsyncResponseHandler;
import darabonba.core.sse.SSEResponseHandler;
import darabonba.core.sse.SSEResponseIterator;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;

public class SSEHttpResponseHandler
implements HttpResponseHandler {
    protected volatile AsyncResponseHandler<?, ?> asyncResponseHandler;
    protected volatile HttpResponseHandler httpResponseHandler;
    protected volatile AsyncResponseHandler<String, ResponseBytes<String>> errorAsyncResponseHandler;

    public SSEHttpResponseHandler(SSEResponseIterator<?> iterator) {
        this.asyncResponseHandler = new SSEResponseHandler(new ByteArrayAsyncResponseHandler(), iterator);
        this.httpResponseHandler = null;
    }

    public SSEHttpResponseHandler(AsyncResponseHandler<?, ?> asyncResponseHandler) {
        this.asyncResponseHandler = asyncResponseHandler;
        this.httpResponseHandler = null;
    }

    public SSEHttpResponseHandler(HttpResponseHandler httpResponseHandler) {
        this.asyncResponseHandler = null;
        this.httpResponseHandler = httpResponseHandler;
    }

    public void onStream(Publisher<ByteBuffer> publisher, int httpStatusCode, HttpHeaders headers) {
        if (httpStatusCode / 100 != 2) {
            this.errorAsyncResponseHandler = AsyncResponseHandler.toBytes();
            this.errorAsyncResponseHandler.onStream(publisher);
        } else if (this.asyncResponseHandler != null) {
            this.asyncResponseHandler.onStream(publisher);
        } else if (this.httpResponseHandler != null) {
            this.httpResponseHandler.onStream(publisher, httpStatusCode, headers);
        }
    }

    public void onError(Throwable throwable) {
        if (this.asyncResponseHandler != null) {
            this.asyncResponseHandler.onError(throwable);
        } else if (this.httpResponseHandler != null) {
            this.httpResponseHandler.onError(throwable);
        }
    }

    public byte[] getErrorBodyByteArrayUnsafe() {
        if (this.errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = this.errorAsyncResponseHandler.transform("");
        return result.asByteArrayUnsafe();
    }

    public byte[] getErrorBodyByteArray() {
        if (this.errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = this.errorAsyncResponseHandler.transform("");
        return result.asByteArray();
    }
}

