/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.http.impl.nio.client;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import shaded.org.apache.http.ConnectionReuseStrategy;
import shaded.org.apache.http.annotation.NotThreadSafe;
import shaded.org.apache.http.client.protocol.RequestAddCookies;
import shaded.org.apache.http.client.protocol.RequestClientConnControl;
import shaded.org.apache.http.client.protocol.ResponseProcessCookies;
import shaded.org.apache.http.conn.ConnectionKeepAliveStrategy;
import shaded.org.apache.http.impl.DefaultConnectionReuseStrategy;
import shaded.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import shaded.org.apache.http.impl.nio.client.IOReactorUtils;
import shaded.org.apache.http.impl.nio.client.MinimalHttpAsyncClient;
import shaded.org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import shaded.org.apache.http.impl.nio.reactor.IOReactorConfig;
import shaded.org.apache.http.nio.conn.NHttpClientConnectionManager;
import shaded.org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import shaded.org.apache.http.protocol.HttpProcessor;
import shaded.org.apache.http.protocol.HttpProcessorBuilder;
import shaded.org.apache.http.protocol.RequestContent;
import shaded.org.apache.http.protocol.RequestTargetHost;
import shaded.org.apache.http.protocol.RequestUserAgent;
import shaded.org.apache.http.util.VersionInfo;

@NotThreadSafe
class MinimalHttpAsyncClientBuilder {
    private NHttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private String userAgent;
    private ThreadFactory threadFactory;
    private boolean cookieManagementDisabled;

    public static MinimalHttpAsyncClientBuilder create() {
        return new MinimalHttpAsyncClientBuilder();
    }

    protected MinimalHttpAsyncClientBuilder() {
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManager(NHttpClientConnectionManager connManager) {
        this.connManager = connManager;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManagerShared(boolean shared) {
        this.connManagerShared = shared;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.keepAliveStrategy = keepAliveStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public MinimalHttpAsyncClient build() {
        String userAgent;
        ConnectionKeepAliveStrategy keepAliveStrategy;
        ConnectionReuseStrategy reuseStrategy;
        NHttpClientConnectionManager connManager = this.connManager;
        if (connManager == null) {
            connManager = new PoolingNHttpClientConnectionManager(IOReactorUtils.create(IOReactorConfig.DEFAULT));
        }
        if ((reuseStrategy = this.reuseStrategy) == null) {
            reuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((keepAliveStrategy = this.keepAliveStrategy) == null) {
            keepAliveStrategy = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((userAgent = this.userAgent) == null) {
            userAgent = VersionInfo.getUserAgent("Apache-HttpAsyncClient", "shaded.org.apache.http.nio.client", this.getClass());
        }
        HttpProcessorBuilder b = HttpProcessorBuilder.create();
        b.addAll(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(userAgent));
        if (!this.cookieManagementDisabled) {
            b.add(new RequestAddCookies());
            b.add(new ResponseProcessCookies());
        }
        HttpProcessor httpprocessor = b.build();
        ThreadFactory threadFactory = null;
        HttpAsyncRequestExecutor eventHandler = null;
        if (!this.connManagerShared) {
            threadFactory = this.threadFactory;
            if (threadFactory == null) {
                threadFactory = Executors.defaultThreadFactory();
            }
            eventHandler = new HttpAsyncRequestExecutor();
        }
        return new MinimalHttpAsyncClient(connManager, threadFactory, eventHandler, httpprocessor, reuseStrategy, keepAliveStrategy);
    }
}

