/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appconfig.model.ActionInvocation;
import com.amazonaws.services.appconfig.model.DeploymentEventType;
import com.amazonaws.services.appconfig.model.TriggeredBy;
import com.amazonaws.services.appconfig.model.transform.DeploymentEventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DeploymentEvent
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventType;
    private String triggeredBy;
    private String description;
    private List<ActionInvocation> actionInvocations;
    private Date occurredAt;

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public DeploymentEvent withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public DeploymentEvent withEventType(DeploymentEventType eventType) {
        this.eventType = eventType.toString();
        return this;
    }

    public void setTriggeredBy(String triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    public String getTriggeredBy() {
        return this.triggeredBy;
    }

    public DeploymentEvent withTriggeredBy(String triggeredBy) {
        this.setTriggeredBy(triggeredBy);
        return this;
    }

    public DeploymentEvent withTriggeredBy(TriggeredBy triggeredBy) {
        this.triggeredBy = triggeredBy.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DeploymentEvent withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ActionInvocation> getActionInvocations() {
        return this.actionInvocations;
    }

    public void setActionInvocations(Collection<ActionInvocation> actionInvocations) {
        if (actionInvocations == null) {
            this.actionInvocations = null;
            return;
        }
        this.actionInvocations = new ArrayList<ActionInvocation>(actionInvocations);
    }

    public DeploymentEvent withActionInvocations(ActionInvocation ... actionInvocations) {
        if (this.actionInvocations == null) {
            this.setActionInvocations(new ArrayList<ActionInvocation>(actionInvocations.length));
        }
        for (ActionInvocation ele : actionInvocations) {
            this.actionInvocations.add(ele);
        }
        return this;
    }

    public DeploymentEvent withActionInvocations(Collection<ActionInvocation> actionInvocations) {
        this.setActionInvocations(actionInvocations);
        return this;
    }

    public void setOccurredAt(Date occurredAt) {
        this.occurredAt = occurredAt;
    }

    public Date getOccurredAt() {
        return this.occurredAt;
    }

    public DeploymentEvent withOccurredAt(Date occurredAt) {
        this.setOccurredAt(occurredAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getTriggeredBy() != null) {
            sb.append("TriggeredBy: ").append(this.getTriggeredBy()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getActionInvocations() != null) {
            sb.append("ActionInvocations: ").append(this.getActionInvocations()).append(",");
        }
        if (this.getOccurredAt() != null) {
            sb.append("OccurredAt: ").append(this.getOccurredAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentEvent)) {
            return false;
        }
        DeploymentEvent other = (DeploymentEvent)obj;
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getTriggeredBy() == null ^ this.getTriggeredBy() == null) {
            return false;
        }
        if (other.getTriggeredBy() != null && !other.getTriggeredBy().equals(this.getTriggeredBy())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getActionInvocations() == null ^ this.getActionInvocations() == null) {
            return false;
        }
        if (other.getActionInvocations() != null && !other.getActionInvocations().equals(this.getActionInvocations())) {
            return false;
        }
        if (other.getOccurredAt() == null ^ this.getOccurredAt() == null) {
            return false;
        }
        return other.getOccurredAt() == null || other.getOccurredAt().equals(this.getOccurredAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getTriggeredBy() == null ? 0 : this.getTriggeredBy().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getActionInvocations() == null ? 0 : this.getActionInvocations().hashCode());
        hashCode = 31 * hashCode + (this.getOccurredAt() == null ? 0 : this.getOccurredAt().hashCode());
        return hashCode;
    }

    public DeploymentEvent clone() {
        try {
            return (DeploymentEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

