/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.OAuth2GrantType;
import com.amazonaws.services.appflow.model.transform.OAuth2PropertiesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OAuth2Properties
implements Serializable,
Cloneable,
StructuredPojo {
    private String tokenUrl;
    private String oAuth2GrantType;
    private Map<String, String> tokenUrlCustomProperties;

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuth2Properties withTokenUrl(String tokenUrl) {
        this.setTokenUrl(tokenUrl);
        return this;
    }

    public void setOAuth2GrantType(String oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType;
    }

    public String getOAuth2GrantType() {
        return this.oAuth2GrantType;
    }

    public OAuth2Properties withOAuth2GrantType(String oAuth2GrantType) {
        this.setOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    public OAuth2Properties withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType.toString();
        return this;
    }

    public Map<String, String> getTokenUrlCustomProperties() {
        return this.tokenUrlCustomProperties;
    }

    public void setTokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
        this.tokenUrlCustomProperties = tokenUrlCustomProperties;
    }

    public OAuth2Properties withTokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
        this.setTokenUrlCustomProperties(tokenUrlCustomProperties);
        return this;
    }

    public OAuth2Properties addTokenUrlCustomPropertiesEntry(String key, String value) {
        if (null == this.tokenUrlCustomProperties) {
            this.tokenUrlCustomProperties = new HashMap<String, String>();
        }
        if (this.tokenUrlCustomProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tokenUrlCustomProperties.put(key, value);
        return this;
    }

    public OAuth2Properties clearTokenUrlCustomPropertiesEntries() {
        this.tokenUrlCustomProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTokenUrl() != null) {
            sb.append("TokenUrl: ").append(this.getTokenUrl()).append(",");
        }
        if (this.getOAuth2GrantType() != null) {
            sb.append("OAuth2GrantType: ").append(this.getOAuth2GrantType()).append(",");
        }
        if (this.getTokenUrlCustomProperties() != null) {
            sb.append("TokenUrlCustomProperties: ").append(this.getTokenUrlCustomProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties)obj;
        if (other.getTokenUrl() == null ^ this.getTokenUrl() == null) {
            return false;
        }
        if (other.getTokenUrl() != null && !other.getTokenUrl().equals(this.getTokenUrl())) {
            return false;
        }
        if (other.getOAuth2GrantType() == null ^ this.getOAuth2GrantType() == null) {
            return false;
        }
        if (other.getOAuth2GrantType() != null && !other.getOAuth2GrantType().equals(this.getOAuth2GrantType())) {
            return false;
        }
        if (other.getTokenUrlCustomProperties() == null ^ this.getTokenUrlCustomProperties() == null) {
            return false;
        }
        return other.getTokenUrlCustomProperties() == null || other.getTokenUrlCustomProperties().equals(this.getTokenUrlCustomProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTokenUrl() == null ? 0 : this.getTokenUrl().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2GrantType() == null ? 0 : this.getOAuth2GrantType().hashCode());
        hashCode = 31 * hashCode + (this.getTokenUrlCustomProperties() == null ? 0 : this.getTokenUrlCustomProperties().hashCode());
        return hashCode;
    }

    public OAuth2Properties clone() {
        try {
            return (OAuth2Properties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OAuth2PropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

