/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.transform.EksMetadataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EksMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> labels;

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public EksMetadata withLabels(Map<String, String> labels) {
        this.setLabels(labels);
        return this;
    }

    public EksMetadata addLabelsEntry(String key, String value) {
        if (null == this.labels) {
            this.labels = new HashMap<String, String>();
        }
        if (this.labels.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.labels.put(key, value);
        return this;
    }

    public EksMetadata clearLabelsEntries() {
        this.labels = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksMetadata)) {
            return false;
        }
        EksMetadata other = (EksMetadata)obj;
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        return other.getLabels() == null || other.getLabels().equals(this.getLabels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        return hashCode;
    }

    public EksMetadata clone() {
        try {
            return (EksMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

