/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.GetRealtimeLogConfigRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetRealtimeLogConfigRequestMarshaller
implements Marshaller<Request<GetRealtimeLogConfigRequest>, GetRealtimeLogConfigRequest> {
    public Request<GetRealtimeLogConfigRequest> marshall(GetRealtimeLogConfigRequest getRealtimeLogConfigRequest) {
        if (getRealtimeLogConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getRealtimeLogConfigRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/get-realtime-log-config/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("GetRealtimeLogConfigRequest");
            if (getRealtimeLogConfigRequest != null) {
                if (getRealtimeLogConfigRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(getRealtimeLogConfigRequest.getName()).endElement();
                }
                if (getRealtimeLogConfigRequest.getARN() != null) {
                    xmlWriter.startElement("ARN").value(getRealtimeLogConfigRequest.getARN()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

