/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildBatchPhaseType;
import com.amazonaws.services.codebuild.model.PhaseContext;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.transform.BuildBatchPhaseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class BuildBatchPhase
implements Serializable,
Cloneable,
StructuredPojo {
    private String phaseType;
    private String phaseStatus;
    private Date startTime;
    private Date endTime;
    private Long durationInSeconds;
    private List<PhaseContext> contexts;

    public void setPhaseType(String phaseType) {
        this.phaseType = phaseType;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public BuildBatchPhase withPhaseType(String phaseType) {
        this.setPhaseType(phaseType);
        return this;
    }

    public BuildBatchPhase withPhaseType(BuildBatchPhaseType phaseType) {
        this.phaseType = phaseType.toString();
        return this;
    }

    public void setPhaseStatus(String phaseStatus) {
        this.phaseStatus = phaseStatus;
    }

    public String getPhaseStatus() {
        return this.phaseStatus;
    }

    public BuildBatchPhase withPhaseStatus(String phaseStatus) {
        this.setPhaseStatus(phaseStatus);
        return this;
    }

    public BuildBatchPhase withPhaseStatus(StatusType phaseStatus) {
        this.phaseStatus = phaseStatus.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BuildBatchPhase withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public BuildBatchPhase withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setDurationInSeconds(Long durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    public Long getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public BuildBatchPhase withDurationInSeconds(Long durationInSeconds) {
        this.setDurationInSeconds(durationInSeconds);
        return this;
    }

    public List<PhaseContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(Collection<PhaseContext> contexts) {
        if (contexts == null) {
            this.contexts = null;
            return;
        }
        this.contexts = new ArrayList<PhaseContext>(contexts);
    }

    public BuildBatchPhase withContexts(PhaseContext ... contexts) {
        if (this.contexts == null) {
            this.setContexts(new ArrayList<PhaseContext>(contexts.length));
        }
        for (PhaseContext ele : contexts) {
            this.contexts.add(ele);
        }
        return this;
    }

    public BuildBatchPhase withContexts(Collection<PhaseContext> contexts) {
        this.setContexts(contexts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPhaseType() != null) {
            sb.append("PhaseType: ").append(this.getPhaseType()).append(",");
        }
        if (this.getPhaseStatus() != null) {
            sb.append("PhaseStatus: ").append(this.getPhaseStatus()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getDurationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(this.getDurationInSeconds()).append(",");
        }
        if (this.getContexts() != null) {
            sb.append("Contexts: ").append(this.getContexts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBatchPhase)) {
            return false;
        }
        BuildBatchPhase other = (BuildBatchPhase)obj;
        if (other.getPhaseType() == null ^ this.getPhaseType() == null) {
            return false;
        }
        if (other.getPhaseType() != null && !other.getPhaseType().equals(this.getPhaseType())) {
            return false;
        }
        if (other.getPhaseStatus() == null ^ this.getPhaseStatus() == null) {
            return false;
        }
        if (other.getPhaseStatus() != null && !other.getPhaseStatus().equals(this.getPhaseStatus())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getDurationInSeconds() == null ^ this.getDurationInSeconds() == null) {
            return false;
        }
        if (other.getDurationInSeconds() != null && !other.getDurationInSeconds().equals(this.getDurationInSeconds())) {
            return false;
        }
        if (other.getContexts() == null ^ this.getContexts() == null) {
            return false;
        }
        return other.getContexts() == null || other.getContexts().equals(this.getContexts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPhaseType() == null ? 0 : this.getPhaseType().hashCode());
        hashCode = 31 * hashCode + (this.getPhaseStatus() == null ? 0 : this.getPhaseStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getDurationInSeconds() == null ? 0 : this.getDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getContexts() == null ? 0 : this.getContexts().hashCode());
        return hashCode;
    }

    public BuildBatchPhase clone() {
        try {
            return (BuildBatchPhase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildBatchPhaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

