/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codebuild.model.WebhookBuildType;
import com.amazonaws.services.codebuild.model.WebhookFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateWebhookRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String projectName;
    private String branchFilter;
    private Boolean rotateSecret;
    private List<List<WebhookFilter>> filterGroups;
    private String buildType;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public UpdateWebhookRequest withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public void setBranchFilter(String branchFilter) {
        this.branchFilter = branchFilter;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public UpdateWebhookRequest withBranchFilter(String branchFilter) {
        this.setBranchFilter(branchFilter);
        return this;
    }

    public void setRotateSecret(Boolean rotateSecret) {
        this.rotateSecret = rotateSecret;
    }

    public Boolean getRotateSecret() {
        return this.rotateSecret;
    }

    public UpdateWebhookRequest withRotateSecret(Boolean rotateSecret) {
        this.setRotateSecret(rotateSecret);
        return this;
    }

    public Boolean isRotateSecret() {
        return this.rotateSecret;
    }

    public List<List<WebhookFilter>> getFilterGroups() {
        return this.filterGroups;
    }

    public void setFilterGroups(Collection<List<WebhookFilter>> filterGroups) {
        if (filterGroups == null) {
            this.filterGroups = null;
            return;
        }
        this.filterGroups = new ArrayList<List<WebhookFilter>>(filterGroups);
    }

    public UpdateWebhookRequest withFilterGroups(List<WebhookFilter> ... filterGroups) {
        if (this.filterGroups == null) {
            this.setFilterGroups(new ArrayList<List<WebhookFilter>>(filterGroups.length));
        }
        for (List<WebhookFilter> ele : filterGroups) {
            this.filterGroups.add(ele);
        }
        return this;
    }

    public UpdateWebhookRequest withFilterGroups(Collection<List<WebhookFilter>> filterGroups) {
        this.setFilterGroups(filterGroups);
        return this;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public UpdateWebhookRequest withBuildType(String buildType) {
        this.setBuildType(buildType);
        return this;
    }

    public UpdateWebhookRequest withBuildType(WebhookBuildType buildType) {
        this.buildType = buildType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getBranchFilter() != null) {
            sb.append("BranchFilter: ").append(this.getBranchFilter()).append(",");
        }
        if (this.getRotateSecret() != null) {
            sb.append("RotateSecret: ").append(this.getRotateSecret()).append(",");
        }
        if (this.getFilterGroups() != null) {
            sb.append("FilterGroups: ").append(this.getFilterGroups()).append(",");
        }
        if (this.getBuildType() != null) {
            sb.append("BuildType: ").append(this.getBuildType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebhookRequest)) {
            return false;
        }
        UpdateWebhookRequest other = (UpdateWebhookRequest)obj;
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getBranchFilter() == null ^ this.getBranchFilter() == null) {
            return false;
        }
        if (other.getBranchFilter() != null && !other.getBranchFilter().equals(this.getBranchFilter())) {
            return false;
        }
        if (other.getRotateSecret() == null ^ this.getRotateSecret() == null) {
            return false;
        }
        if (other.getRotateSecret() != null && !other.getRotateSecret().equals(this.getRotateSecret())) {
            return false;
        }
        if (other.getFilterGroups() == null ^ this.getFilterGroups() == null) {
            return false;
        }
        if (other.getFilterGroups() != null && !other.getFilterGroups().equals(this.getFilterGroups())) {
            return false;
        }
        if (other.getBuildType() == null ^ this.getBuildType() == null) {
            return false;
        }
        return other.getBuildType() == null || other.getBuildType().equals(this.getBuildType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getBranchFilter() == null ? 0 : this.getBranchFilter().hashCode());
        hashCode = 31 * hashCode + (this.getRotateSecret() == null ? 0 : this.getRotateSecret().hashCode());
        hashCode = 31 * hashCode + (this.getFilterGroups() == null ? 0 : this.getFilterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getBuildType() == null ? 0 : this.getBuildType().hashCode());
        return hashCode;
    }

    public UpdateWebhookRequest clone() {
        return (UpdateWebhookRequest)super.clone();
    }
}

