/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.AgentAvailabilityTimer;
import com.amazonaws.services.connect.model.MediaConcurrency;
import com.amazonaws.services.connect.model.transform.RoutingProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoutingProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceId;
    private String name;
    private String routingProfileArn;
    private String routingProfileId;
    private String description;
    private List<MediaConcurrency> mediaConcurrencies;
    private String defaultOutboundQueueId;
    private Map<String, String> tags;
    private Long numberOfAssociatedQueues;
    private Long numberOfAssociatedUsers;
    private String agentAvailabilityTimer;
    private Date lastModifiedTime;
    private String lastModifiedRegion;
    private Boolean isDefault;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public RoutingProfile withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RoutingProfile withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRoutingProfileArn(String routingProfileArn) {
        this.routingProfileArn = routingProfileArn;
    }

    public String getRoutingProfileArn() {
        return this.routingProfileArn;
    }

    public RoutingProfile withRoutingProfileArn(String routingProfileArn) {
        this.setRoutingProfileArn(routingProfileArn);
        return this;
    }

    public void setRoutingProfileId(String routingProfileId) {
        this.routingProfileId = routingProfileId;
    }

    public String getRoutingProfileId() {
        return this.routingProfileId;
    }

    public RoutingProfile withRoutingProfileId(String routingProfileId) {
        this.setRoutingProfileId(routingProfileId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RoutingProfile withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<MediaConcurrency> getMediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public void setMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        if (mediaConcurrencies == null) {
            this.mediaConcurrencies = null;
            return;
        }
        this.mediaConcurrencies = new ArrayList<MediaConcurrency>(mediaConcurrencies);
    }

    public RoutingProfile withMediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
        if (this.mediaConcurrencies == null) {
            this.setMediaConcurrencies(new ArrayList<MediaConcurrency>(mediaConcurrencies.length));
        }
        for (MediaConcurrency ele : mediaConcurrencies) {
            this.mediaConcurrencies.add(ele);
        }
        return this;
    }

    public RoutingProfile withMediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
        this.setMediaConcurrencies(mediaConcurrencies);
        return this;
    }

    public void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
        this.defaultOutboundQueueId = defaultOutboundQueueId;
    }

    public String getDefaultOutboundQueueId() {
        return this.defaultOutboundQueueId;
    }

    public RoutingProfile withDefaultOutboundQueueId(String defaultOutboundQueueId) {
        this.setDefaultOutboundQueueId(defaultOutboundQueueId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RoutingProfile withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public RoutingProfile addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public RoutingProfile clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setNumberOfAssociatedQueues(Long numberOfAssociatedQueues) {
        this.numberOfAssociatedQueues = numberOfAssociatedQueues;
    }

    public Long getNumberOfAssociatedQueues() {
        return this.numberOfAssociatedQueues;
    }

    public RoutingProfile withNumberOfAssociatedQueues(Long numberOfAssociatedQueues) {
        this.setNumberOfAssociatedQueues(numberOfAssociatedQueues);
        return this;
    }

    public void setNumberOfAssociatedUsers(Long numberOfAssociatedUsers) {
        this.numberOfAssociatedUsers = numberOfAssociatedUsers;
    }

    public Long getNumberOfAssociatedUsers() {
        return this.numberOfAssociatedUsers;
    }

    public RoutingProfile withNumberOfAssociatedUsers(Long numberOfAssociatedUsers) {
        this.setNumberOfAssociatedUsers(numberOfAssociatedUsers);
        return this;
    }

    public void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
        this.agentAvailabilityTimer = agentAvailabilityTimer;
    }

    public String getAgentAvailabilityTimer() {
        return this.agentAvailabilityTimer;
    }

    public RoutingProfile withAgentAvailabilityTimer(String agentAvailabilityTimer) {
        this.setAgentAvailabilityTimer(agentAvailabilityTimer);
        return this;
    }

    public RoutingProfile withAgentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
        this.agentAvailabilityTimer = agentAvailabilityTimer.toString();
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public RoutingProfile withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setLastModifiedRegion(String lastModifiedRegion) {
        this.lastModifiedRegion = lastModifiedRegion;
    }

    public String getLastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public RoutingProfile withLastModifiedRegion(String lastModifiedRegion) {
        this.setLastModifiedRegion(lastModifiedRegion);
        return this;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public RoutingProfile withIsDefault(Boolean isDefault) {
        this.setIsDefault(isDefault);
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRoutingProfileArn() != null) {
            sb.append("RoutingProfileArn: ").append(this.getRoutingProfileArn()).append(",");
        }
        if (this.getRoutingProfileId() != null) {
            sb.append("RoutingProfileId: ").append(this.getRoutingProfileId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getMediaConcurrencies() != null) {
            sb.append("MediaConcurrencies: ").append(this.getMediaConcurrencies()).append(",");
        }
        if (this.getDefaultOutboundQueueId() != null) {
            sb.append("DefaultOutboundQueueId: ").append(this.getDefaultOutboundQueueId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getNumberOfAssociatedQueues() != null) {
            sb.append("NumberOfAssociatedQueues: ").append(this.getNumberOfAssociatedQueues()).append(",");
        }
        if (this.getNumberOfAssociatedUsers() != null) {
            sb.append("NumberOfAssociatedUsers: ").append(this.getNumberOfAssociatedUsers()).append(",");
        }
        if (this.getAgentAvailabilityTimer() != null) {
            sb.append("AgentAvailabilityTimer: ").append(this.getAgentAvailabilityTimer()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getLastModifiedRegion() != null) {
            sb.append("LastModifiedRegion: ").append(this.getLastModifiedRegion()).append(",");
        }
        if (this.getIsDefault() != null) {
            sb.append("IsDefault: ").append(this.getIsDefault());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfile)) {
            return false;
        }
        RoutingProfile other = (RoutingProfile)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRoutingProfileArn() == null ^ this.getRoutingProfileArn() == null) {
            return false;
        }
        if (other.getRoutingProfileArn() != null && !other.getRoutingProfileArn().equals(this.getRoutingProfileArn())) {
            return false;
        }
        if (other.getRoutingProfileId() == null ^ this.getRoutingProfileId() == null) {
            return false;
        }
        if (other.getRoutingProfileId() != null && !other.getRoutingProfileId().equals(this.getRoutingProfileId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getMediaConcurrencies() == null ^ this.getMediaConcurrencies() == null) {
            return false;
        }
        if (other.getMediaConcurrencies() != null && !other.getMediaConcurrencies().equals(this.getMediaConcurrencies())) {
            return false;
        }
        if (other.getDefaultOutboundQueueId() == null ^ this.getDefaultOutboundQueueId() == null) {
            return false;
        }
        if (other.getDefaultOutboundQueueId() != null && !other.getDefaultOutboundQueueId().equals(this.getDefaultOutboundQueueId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getNumberOfAssociatedQueues() == null ^ this.getNumberOfAssociatedQueues() == null) {
            return false;
        }
        if (other.getNumberOfAssociatedQueues() != null && !other.getNumberOfAssociatedQueues().equals(this.getNumberOfAssociatedQueues())) {
            return false;
        }
        if (other.getNumberOfAssociatedUsers() == null ^ this.getNumberOfAssociatedUsers() == null) {
            return false;
        }
        if (other.getNumberOfAssociatedUsers() != null && !other.getNumberOfAssociatedUsers().equals(this.getNumberOfAssociatedUsers())) {
            return false;
        }
        if (other.getAgentAvailabilityTimer() == null ^ this.getAgentAvailabilityTimer() == null) {
            return false;
        }
        if (other.getAgentAvailabilityTimer() != null && !other.getAgentAvailabilityTimer().equals(this.getAgentAvailabilityTimer())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getLastModifiedRegion() == null ^ this.getLastModifiedRegion() == null) {
            return false;
        }
        if (other.getLastModifiedRegion() != null && !other.getLastModifiedRegion().equals(this.getLastModifiedRegion())) {
            return false;
        }
        if (other.getIsDefault() == null ^ this.getIsDefault() == null) {
            return false;
        }
        return other.getIsDefault() == null || other.getIsDefault().equals(this.getIsDefault());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingProfileArn() == null ? 0 : this.getRoutingProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingProfileId() == null ? 0 : this.getRoutingProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getMediaConcurrencies() == null ? 0 : this.getMediaConcurrencies().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultOutboundQueueId() == null ? 0 : this.getDefaultOutboundQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfAssociatedQueues() == null ? 0 : this.getNumberOfAssociatedQueues().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfAssociatedUsers() == null ? 0 : this.getNumberOfAssociatedUsers().hashCode());
        hashCode = 31 * hashCode + (this.getAgentAvailabilityTimer() == null ? 0 : this.getAgentAvailabilityTimer().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedRegion() == null ? 0 : this.getLastModifiedRegion().hashCode());
        hashCode = 31 * hashCode + (this.getIsDefault() == null ? 0 : this.getIsDefault().hashCode());
        return hashCode;
    }

    public RoutingProfile clone() {
        try {
            return (RoutingProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoutingProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

