/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains summary information about a flow.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ContactFlowModuleSummary" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ContactFlowModuleSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The name of the flow module.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The type of flow module.
     * </p>
     */
    private String state;

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @param id
     *        The identifier of the flow module.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @param id
     *        The identifier of the flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContactFlowModuleSummary withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the flow module.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow module.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContactFlowModuleSummary withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The name of the flow module.
     * </p>
     * 
     * @param name
     *        The name of the flow module.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the flow module.
     * </p>
     * 
     * @return The name of the flow module.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the flow module.
     * </p>
     * 
     * @param name
     *        The name of the flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContactFlowModuleSummary withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * 
     * @param state
     *        The type of flow module.
     * @see ContactFlowModuleState
     */

    public void setState(String state) {
        this.state = state;
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * 
     * @return The type of flow module.
     * @see ContactFlowModuleState
     */

    public String getState() {
        return this.state;
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * 
     * @param state
     *        The type of flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ContactFlowModuleState
     */

    public ContactFlowModuleSummary withState(String state) {
        setState(state);
        return this;
    }

    /**
     * <p>
     * The type of flow module.
     * </p>
     * 
     * @param state
     *        The type of flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ContactFlowModuleState
     */

    public ContactFlowModuleSummary withState(ContactFlowModuleState state) {
        this.state = state.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getState() != null)
            sb.append("State: ").append(getState());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ContactFlowModuleSummary == false)
            return false;
        ContactFlowModuleSummary other = (ContactFlowModuleSummary) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getState() == null ^ this.getState() == null)
            return false;
        if (other.getState() != null && other.getState().equals(this.getState()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getState() == null) ? 0 : getState().hashCode());
        return hashCode;
    }

    @Override
    public ContactFlowModuleSummary clone() {
        try {
            return (ContactFlowModuleSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.ContactFlowModuleSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
