/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListEvaluationFormsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     */
    private java.util.List<EvaluationFormSummary> evaluationFormSummaryList;
    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     * 
     * @return Provides details about a list of evaluation forms belonging to an instance.
     */

    public java.util.List<EvaluationFormSummary> getEvaluationFormSummaryList() {
        return evaluationFormSummaryList;
    }

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     * 
     * @param evaluationFormSummaryList
     *        Provides details about a list of evaluation forms belonging to an instance.
     */

    public void setEvaluationFormSummaryList(java.util.Collection<EvaluationFormSummary> evaluationFormSummaryList) {
        if (evaluationFormSummaryList == null) {
            this.evaluationFormSummaryList = null;
            return;
        }

        this.evaluationFormSummaryList = new java.util.ArrayList<EvaluationFormSummary>(evaluationFormSummaryList);
    }

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEvaluationFormSummaryList(java.util.Collection)} or
     * {@link #withEvaluationFormSummaryList(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param evaluationFormSummaryList
     *        Provides details about a list of evaluation forms belonging to an instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEvaluationFormsResult withEvaluationFormSummaryList(EvaluationFormSummary... evaluationFormSummaryList) {
        if (this.evaluationFormSummaryList == null) {
            setEvaluationFormSummaryList(new java.util.ArrayList<EvaluationFormSummary>(evaluationFormSummaryList.length));
        }
        for (EvaluationFormSummary ele : evaluationFormSummaryList) {
            this.evaluationFormSummaryList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     * 
     * @param evaluationFormSummaryList
     *        Provides details about a list of evaluation forms belonging to an instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEvaluationFormsResult withEvaluationFormSummaryList(java.util.Collection<EvaluationFormSummary> evaluationFormSummaryList) {
        setEvaluationFormSummaryList(evaluationFormSummaryList);
        return this;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @param nextToken
     *        If there are additional results, this is the token for the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListEvaluationFormsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEvaluationFormSummaryList() != null)
            sb.append("EvaluationFormSummaryList: ").append(getEvaluationFormSummaryList()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListEvaluationFormsResult == false)
            return false;
        ListEvaluationFormsResult other = (ListEvaluationFormsResult) obj;
        if (other.getEvaluationFormSummaryList() == null ^ this.getEvaluationFormSummaryList() == null)
            return false;
        if (other.getEvaluationFormSummaryList() != null && other.getEvaluationFormSummaryList().equals(this.getEvaluationFormSummaryList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEvaluationFormSummaryList() == null) ? 0 : getEvaluationFormSummaryList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListEvaluationFormsResult clone() {
        try {
            return (ListEvaluationFormsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
