/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.DefaultQueueBudgetAction;
import com.amazonaws.services.deadline.model.JobAttachmentSettings;
import com.amazonaws.services.deadline.model.JobRunAsUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateQueueRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> allowedStorageProfileIds;
    private String clientToken;
    private String defaultBudgetAction;
    private String description;
    private String displayName;
    private String farmId;
    private JobAttachmentSettings jobAttachmentSettings;
    private JobRunAsUser jobRunAsUser;
    private List<String> requiredFileSystemLocationNames;
    private String roleArn;
    private Map<String, String> tags;

    public List<String> getAllowedStorageProfileIds() {
        return this.allowedStorageProfileIds;
    }

    public void setAllowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
        if (allowedStorageProfileIds == null) {
            this.allowedStorageProfileIds = null;
            return;
        }
        this.allowedStorageProfileIds = new ArrayList<String>(allowedStorageProfileIds);
    }

    public CreateQueueRequest withAllowedStorageProfileIds(String ... allowedStorageProfileIds) {
        if (this.allowedStorageProfileIds == null) {
            this.setAllowedStorageProfileIds(new ArrayList<String>(allowedStorageProfileIds.length));
        }
        for (String ele : allowedStorageProfileIds) {
            this.allowedStorageProfileIds.add(ele);
        }
        return this;
    }

    public CreateQueueRequest withAllowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
        this.setAllowedStorageProfileIds(allowedStorageProfileIds);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateQueueRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDefaultBudgetAction(String defaultBudgetAction) {
        this.defaultBudgetAction = defaultBudgetAction;
    }

    public String getDefaultBudgetAction() {
        return this.defaultBudgetAction;
    }

    public CreateQueueRequest withDefaultBudgetAction(String defaultBudgetAction) {
        this.setDefaultBudgetAction(defaultBudgetAction);
        return this;
    }

    public CreateQueueRequest withDefaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
        this.defaultBudgetAction = defaultBudgetAction.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateQueueRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateQueueRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public CreateQueueRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public void setJobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
        this.jobAttachmentSettings = jobAttachmentSettings;
    }

    public JobAttachmentSettings getJobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public CreateQueueRequest withJobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
        this.setJobAttachmentSettings(jobAttachmentSettings);
        return this;
    }

    public void setJobRunAsUser(JobRunAsUser jobRunAsUser) {
        this.jobRunAsUser = jobRunAsUser;
    }

    public JobRunAsUser getJobRunAsUser() {
        return this.jobRunAsUser;
    }

    public CreateQueueRequest withJobRunAsUser(JobRunAsUser jobRunAsUser) {
        this.setJobRunAsUser(jobRunAsUser);
        return this;
    }

    public List<String> getRequiredFileSystemLocationNames() {
        return this.requiredFileSystemLocationNames;
    }

    public void setRequiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
        if (requiredFileSystemLocationNames == null) {
            this.requiredFileSystemLocationNames = null;
            return;
        }
        this.requiredFileSystemLocationNames = new ArrayList<String>(requiredFileSystemLocationNames);
    }

    public CreateQueueRequest withRequiredFileSystemLocationNames(String ... requiredFileSystemLocationNames) {
        if (this.requiredFileSystemLocationNames == null) {
            this.setRequiredFileSystemLocationNames(new ArrayList<String>(requiredFileSystemLocationNames.length));
        }
        for (String ele : requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames.add(ele);
        }
        return this;
    }

    public CreateQueueRequest withRequiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
        this.setRequiredFileSystemLocationNames(requiredFileSystemLocationNames);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateQueueRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateQueueRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateQueueRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateQueueRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedStorageProfileIds() != null) {
            sb.append("AllowedStorageProfileIds: ").append(this.getAllowedStorageProfileIds()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDefaultBudgetAction() != null) {
            sb.append("DefaultBudgetAction: ").append(this.getDefaultBudgetAction()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getJobAttachmentSettings() != null) {
            sb.append("JobAttachmentSettings: ").append(this.getJobAttachmentSettings()).append(",");
        }
        if (this.getJobRunAsUser() != null) {
            sb.append("JobRunAsUser: ").append(this.getJobRunAsUser()).append(",");
        }
        if (this.getRequiredFileSystemLocationNames() != null) {
            sb.append("RequiredFileSystemLocationNames: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)obj;
        if (other.getAllowedStorageProfileIds() == null ^ this.getAllowedStorageProfileIds() == null) {
            return false;
        }
        if (other.getAllowedStorageProfileIds() != null && !other.getAllowedStorageProfileIds().equals(this.getAllowedStorageProfileIds())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDefaultBudgetAction() == null ^ this.getDefaultBudgetAction() == null) {
            return false;
        }
        if (other.getDefaultBudgetAction() != null && !other.getDefaultBudgetAction().equals(this.getDefaultBudgetAction())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getJobAttachmentSettings() == null ^ this.getJobAttachmentSettings() == null) {
            return false;
        }
        if (other.getJobAttachmentSettings() != null && !other.getJobAttachmentSettings().equals(this.getJobAttachmentSettings())) {
            return false;
        }
        if (other.getJobRunAsUser() == null ^ this.getJobRunAsUser() == null) {
            return false;
        }
        if (other.getJobRunAsUser() != null && !other.getJobRunAsUser().equals(this.getJobRunAsUser())) {
            return false;
        }
        if (other.getRequiredFileSystemLocationNames() == null ^ this.getRequiredFileSystemLocationNames() == null) {
            return false;
        }
        if (other.getRequiredFileSystemLocationNames() != null && !other.getRequiredFileSystemLocationNames().equals(this.getRequiredFileSystemLocationNames())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedStorageProfileIds() == null ? 0 : this.getAllowedStorageProfileIds().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultBudgetAction() == null ? 0 : this.getDefaultBudgetAction().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getJobAttachmentSettings() == null ? 0 : this.getJobAttachmentSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJobRunAsUser() == null ? 0 : this.getJobRunAsUser().hashCode());
        hashCode = 31 * hashCode + (this.getRequiredFileSystemLocationNames() == null ? 0 : this.getRequiredFileSystemLocationNames().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateQueueRequest clone() {
        return (CreateQueueRequest)super.clone();
    }
}

