/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.detective.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateMembers" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateMembersRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     */
    private String graphArn;
    /**
     * <p>
     * Customized message text to include in the invitation email message to the invited member accounts.
     * </p>
     */
    private String message;
    /**
     * <p>
     * if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is
     * set to <code>false</code>, and the invited accounts receive email notifications.
     * </p>
     * <p>
     * Organization accounts in the organization behavior graph do not receive email notifications.
     * </p>
     */
    private Boolean disableEmailNotification;
    /**
     * <p>
     * The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a
     * time. For each invited account, the account list contains the account identifier and the Amazon Web Services
     * account root user email address. For organization accounts in the organization behavior graph, the email address
     * is not required.
     * </p>
     */
    private java.util.List<Account> accounts;

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @param graphArn
     *        The ARN of the behavior graph.
     */

    public void setGraphArn(String graphArn) {
        this.graphArn = graphArn;
    }

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @return The ARN of the behavior graph.
     */

    public String getGraphArn() {
        return this.graphArn;
    }

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @param graphArn
     *        The ARN of the behavior graph.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMembersRequest withGraphArn(String graphArn) {
        setGraphArn(graphArn);
        return this;
    }

    /**
     * <p>
     * Customized message text to include in the invitation email message to the invited member accounts.
     * </p>
     * 
     * @param message
     *        Customized message text to include in the invitation email message to the invited member accounts.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * Customized message text to include in the invitation email message to the invited member accounts.
     * </p>
     * 
     * @return Customized message text to include in the invitation email message to the invited member accounts.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * Customized message text to include in the invitation email message to the invited member accounts.
     * </p>
     * 
     * @param message
     *        Customized message text to include in the invitation email message to the invited member accounts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMembersRequest withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is
     * set to <code>false</code>, and the invited accounts receive email notifications.
     * </p>
     * <p>
     * Organization accounts in the organization behavior graph do not receive email notifications.
     * </p>
     * 
     * @param disableEmailNotification
     *        if set to <code>true</code>, then the invited accounts do not receive email notifications. By default,
     *        this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
     *        <p>
     *        Organization accounts in the organization behavior graph do not receive email notifications.
     */

    public void setDisableEmailNotification(Boolean disableEmailNotification) {
        this.disableEmailNotification = disableEmailNotification;
    }

    /**
     * <p>
     * if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is
     * set to <code>false</code>, and the invited accounts receive email notifications.
     * </p>
     * <p>
     * Organization accounts in the organization behavior graph do not receive email notifications.
     * </p>
     * 
     * @return if set to <code>true</code>, then the invited accounts do not receive email notifications. By default,
     *         this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
     *         <p>
     *         Organization accounts in the organization behavior graph do not receive email notifications.
     */

    public Boolean getDisableEmailNotification() {
        return this.disableEmailNotification;
    }

    /**
     * <p>
     * if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is
     * set to <code>false</code>, and the invited accounts receive email notifications.
     * </p>
     * <p>
     * Organization accounts in the organization behavior graph do not receive email notifications.
     * </p>
     * 
     * @param disableEmailNotification
     *        if set to <code>true</code>, then the invited accounts do not receive email notifications. By default,
     *        this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
     *        <p>
     *        Organization accounts in the organization behavior graph do not receive email notifications.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMembersRequest withDisableEmailNotification(Boolean disableEmailNotification) {
        setDisableEmailNotification(disableEmailNotification);
        return this;
    }

    /**
     * <p>
     * if set to <code>true</code>, then the invited accounts do not receive email notifications. By default, this is
     * set to <code>false</code>, and the invited accounts receive email notifications.
     * </p>
     * <p>
     * Organization accounts in the organization behavior graph do not receive email notifications.
     * </p>
     * 
     * @return if set to <code>true</code>, then the invited accounts do not receive email notifications. By default,
     *         this is set to <code>false</code>, and the invited accounts receive email notifications.</p>
     *         <p>
     *         Organization accounts in the organization behavior graph do not receive email notifications.
     */

    public Boolean isDisableEmailNotification() {
        return this.disableEmailNotification;
    }

    /**
     * <p>
     * The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a
     * time. For each invited account, the account list contains the account identifier and the Amazon Web Services
     * account root user email address. For organization accounts in the organization behavior graph, the email address
     * is not required.
     * </p>
     * 
     * @return The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50
     *         accounts at a time. For each invited account, the account list contains the account identifier and the
     *         Amazon Web Services account root user email address. For organization accounts in the organization
     *         behavior graph, the email address is not required.
     */

    public java.util.List<Account> getAccounts() {
        return accounts;
    }

    /**
     * <p>
     * The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a
     * time. For each invited account, the account list contains the account identifier and the Amazon Web Services
     * account root user email address. For organization accounts in the organization behavior graph, the email address
     * is not required.
     * </p>
     * 
     * @param accounts
     *        The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50
     *        accounts at a time. For each invited account, the account list contains the account identifier and the
     *        Amazon Web Services account root user email address. For organization accounts in the organization
     *        behavior graph, the email address is not required.
     */

    public void setAccounts(java.util.Collection<Account> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }

        this.accounts = new java.util.ArrayList<Account>(accounts);
    }

    /**
     * <p>
     * The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a
     * time. For each invited account, the account list contains the account identifier and the Amazon Web Services
     * account root user email address. For organization accounts in the organization behavior graph, the email address
     * is not required.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAccounts(java.util.Collection)} or {@link #withAccounts(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param accounts
     *        The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50
     *        accounts at a time. For each invited account, the account list contains the account identifier and the
     *        Amazon Web Services account root user email address. For organization accounts in the organization
     *        behavior graph, the email address is not required.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMembersRequest withAccounts(Account... accounts) {
        if (this.accounts == null) {
            setAccounts(new java.util.ArrayList<Account>(accounts.length));
        }
        for (Account ele : accounts) {
            this.accounts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50 accounts at a
     * time. For each invited account, the account list contains the account identifier and the Amazon Web Services
     * account root user email address. For organization accounts in the organization behavior graph, the email address
     * is not required.
     * </p>
     * 
     * @param accounts
     *        The list of Amazon Web Services accounts to invite or to enable. You can invite or enable up to 50
     *        accounts at a time. For each invited account, the account list contains the account identifier and the
     *        Amazon Web Services account root user email address. For organization accounts in the organization
     *        behavior graph, the email address is not required.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMembersRequest withAccounts(java.util.Collection<Account> accounts) {
        setAccounts(accounts);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGraphArn() != null)
            sb.append("GraphArn: ").append(getGraphArn()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getDisableEmailNotification() != null)
            sb.append("DisableEmailNotification: ").append(getDisableEmailNotification()).append(",");
        if (getAccounts() != null)
            sb.append("Accounts: ").append(getAccounts());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateMembersRequest == false)
            return false;
        CreateMembersRequest other = (CreateMembersRequest) obj;
        if (other.getGraphArn() == null ^ this.getGraphArn() == null)
            return false;
        if (other.getGraphArn() != null && other.getGraphArn().equals(this.getGraphArn()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getDisableEmailNotification() == null ^ this.getDisableEmailNotification() == null)
            return false;
        if (other.getDisableEmailNotification() != null && other.getDisableEmailNotification().equals(this.getDisableEmailNotification()) == false)
            return false;
        if (other.getAccounts() == null ^ this.getAccounts() == null)
            return false;
        if (other.getAccounts() != null && other.getAccounts().equals(this.getAccounts()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGraphArn() == null) ? 0 : getGraphArn().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getDisableEmailNotification() == null) ? 0 : getDisableEmailNotification().hashCode());
        hashCode = prime * hashCode + ((getAccounts() == null) ? 0 : getAccounts().hashCode());
        return hashCode;
    }

    @Override
    public CreateMembersRequest clone() {
        return (CreateMembersRequest) super.clone();
    }

}
