/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.applicationdiscovery.model.ImportTask;
import java.util.Date;

@SdkInternalApi
public class ImportTaskMarshaller {
    private static final MarshallingInfo<String> IMPORTTASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("importTaskId").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientRequestToken").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> IMPORTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("importUrl").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> IMPORTREQUESTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("importRequestTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> IMPORTCOMPLETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("importCompletionTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> IMPORTDELETEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("importDeletedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> SERVERIMPORTSUCCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverImportSuccess").build();
    private static final MarshallingInfo<Integer> SERVERIMPORTFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverImportFailure").build();
    private static final MarshallingInfo<Integer> APPLICATIONIMPORTSUCCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationImportSuccess").build();
    private static final MarshallingInfo<Integer> APPLICATIONIMPORTFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationImportFailure").build();
    private static final MarshallingInfo<String> ERRORSANDFAILEDENTRIESZIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorsAndFailedEntriesZip").build();
    private static final ImportTaskMarshaller instance = new ImportTaskMarshaller();

    public static ImportTaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportTask importTask, ProtocolMarshaller protocolMarshaller) {
        if (importTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importTask.getImportTaskId(), IMPORTTASKID_BINDING);
            protocolMarshaller.marshall((Object)importTask.getClientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importTask.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)importTask.getImportUrl(), IMPORTURL_BINDING);
            protocolMarshaller.marshall((Object)importTask.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)importTask.getImportRequestTime(), IMPORTREQUESTTIME_BINDING);
            protocolMarshaller.marshall((Object)importTask.getImportCompletionTime(), IMPORTCOMPLETIONTIME_BINDING);
            protocolMarshaller.marshall((Object)importTask.getImportDeletedTime(), IMPORTDELETEDTIME_BINDING);
            protocolMarshaller.marshall((Object)importTask.getServerImportSuccess(), SERVERIMPORTSUCCESS_BINDING);
            protocolMarshaller.marshall((Object)importTask.getServerImportFailure(), SERVERIMPORTFAILURE_BINDING);
            protocolMarshaller.marshall((Object)importTask.getApplicationImportSuccess(), APPLICATIONIMPORTSUCCESS_BINDING);
            protocolMarshaller.marshall((Object)importTask.getApplicationImportFailure(), APPLICATIONIMPORTFAILURE_BINDING);
            protocolMarshaller.marshall((Object)importTask.getErrorsAndFailedEntriesZip(), ERRORSANDFAILEDENTRIESZIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

