/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.Experiment;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ExperimentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> EXPERIMENTTEMPLATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("experimentTemplateId").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<Map> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").build();
    private static final MarshallingInfo<Map> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<List> STOPCONDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopConditions").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final ExperimentMarshaller instance = new ExperimentMarshaller();

    public static ExperimentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Experiment experiment, ProtocolMarshaller protocolMarshaller) {
        if (experiment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)experiment.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)experiment.getExperimentTemplateId(), EXPERIMENTTEMPLATEID_BINDING);
            protocolMarshaller.marshall((Object)experiment.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)experiment.getState(), STATE_BINDING);
            protocolMarshaller.marshall(experiment.getTargets(), TARGETS_BINDING);
            protocolMarshaller.marshall(experiment.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(experiment.getStopConditions(), STOPCONDITIONS_BINDING);
            protocolMarshaller.marshall((Object)experiment.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)experiment.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)experiment.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(experiment.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

