/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.ConfigurationObject;
import com.amazonaws.services.glue.model.transform.ProfileConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProfileConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, ConfigurationObject> sessionConfiguration;
    private Map<String, ConfigurationObject> jobConfiguration;

    public Map<String, ConfigurationObject> getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public void setSessionConfiguration(Map<String, ConfigurationObject> sessionConfiguration) {
        this.sessionConfiguration = sessionConfiguration;
    }

    public ProfileConfiguration withSessionConfiguration(Map<String, ConfigurationObject> sessionConfiguration) {
        this.setSessionConfiguration(sessionConfiguration);
        return this;
    }

    public ProfileConfiguration addSessionConfigurationEntry(String key, ConfigurationObject value) {
        if (null == this.sessionConfiguration) {
            this.sessionConfiguration = new HashMap<String, ConfigurationObject>();
        }
        if (this.sessionConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sessionConfiguration.put(key, value);
        return this;
    }

    public ProfileConfiguration clearSessionConfigurationEntries() {
        this.sessionConfiguration = null;
        return this;
    }

    public Map<String, ConfigurationObject> getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(Map<String, ConfigurationObject> jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public ProfileConfiguration withJobConfiguration(Map<String, ConfigurationObject> jobConfiguration) {
        this.setJobConfiguration(jobConfiguration);
        return this;
    }

    public ProfileConfiguration addJobConfigurationEntry(String key, ConfigurationObject value) {
        if (null == this.jobConfiguration) {
            this.jobConfiguration = new HashMap<String, ConfigurationObject>();
        }
        if (this.jobConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.jobConfiguration.put(key, value);
        return this;
    }

    public ProfileConfiguration clearJobConfigurationEntries() {
        this.jobConfiguration = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSessionConfiguration() != null) {
            sb.append("SessionConfiguration: ").append(this.getSessionConfiguration()).append(",");
        }
        if (this.getJobConfiguration() != null) {
            sb.append("JobConfiguration: ").append(this.getJobConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)obj;
        if (other.getSessionConfiguration() == null ^ this.getSessionConfiguration() == null) {
            return false;
        }
        if (other.getSessionConfiguration() != null && !other.getSessionConfiguration().equals(this.getSessionConfiguration())) {
            return false;
        }
        if (other.getJobConfiguration() == null ^ this.getJobConfiguration() == null) {
            return false;
        }
        return other.getJobConfiguration() == null || other.getJobConfiguration().equals(this.getJobConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSessionConfiguration() == null ? 0 : this.getSessionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getJobConfiguration() == null ? 0 : this.getJobConfiguration().hashCode());
        return hashCode;
    }

    public ProfileConfiguration clone() {
        try {
            return (ProfileConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

