/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.AccessKeyDetails;
import com.amazonaws.services.guardduty.model.InstanceDetails;
import com.amazonaws.services.guardduty.model.S3BucketDetail;
import com.amazonaws.services.guardduty.model.transform.ResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private AccessKeyDetails accessKeyDetails;
    private List<S3BucketDetail> s3BucketDetails;
    private InstanceDetails instanceDetails;
    private String resourceType;

    public void setAccessKeyDetails(AccessKeyDetails accessKeyDetails) {
        this.accessKeyDetails = accessKeyDetails;
    }

    public AccessKeyDetails getAccessKeyDetails() {
        return this.accessKeyDetails;
    }

    public Resource withAccessKeyDetails(AccessKeyDetails accessKeyDetails) {
        this.setAccessKeyDetails(accessKeyDetails);
        return this;
    }

    public List<S3BucketDetail> getS3BucketDetails() {
        return this.s3BucketDetails;
    }

    public void setS3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
        if (s3BucketDetails == null) {
            this.s3BucketDetails = null;
            return;
        }
        this.s3BucketDetails = new ArrayList<S3BucketDetail>(s3BucketDetails);
    }

    public Resource withS3BucketDetails(S3BucketDetail ... s3BucketDetails) {
        if (this.s3BucketDetails == null) {
            this.setS3BucketDetails(new ArrayList<S3BucketDetail>(s3BucketDetails.length));
        }
        for (S3BucketDetail ele : s3BucketDetails) {
            this.s3BucketDetails.add(ele);
        }
        return this;
    }

    public Resource withS3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
        this.setS3BucketDetails(s3BucketDetails);
        return this;
    }

    public void setInstanceDetails(InstanceDetails instanceDetails) {
        this.instanceDetails = instanceDetails;
    }

    public InstanceDetails getInstanceDetails() {
        return this.instanceDetails;
    }

    public Resource withInstanceDetails(InstanceDetails instanceDetails) {
        this.setInstanceDetails(instanceDetails);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Resource withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessKeyDetails() != null) {
            sb.append("AccessKeyDetails: ").append(this.getAccessKeyDetails()).append(",");
        }
        if (this.getS3BucketDetails() != null) {
            sb.append("S3BucketDetails: ").append(this.getS3BucketDetails()).append(",");
        }
        if (this.getInstanceDetails() != null) {
            sb.append("InstanceDetails: ").append(this.getInstanceDetails()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getAccessKeyDetails() == null ^ this.getAccessKeyDetails() == null) {
            return false;
        }
        if (other.getAccessKeyDetails() != null && !other.getAccessKeyDetails().equals(this.getAccessKeyDetails())) {
            return false;
        }
        if (other.getS3BucketDetails() == null ^ this.getS3BucketDetails() == null) {
            return false;
        }
        if (other.getS3BucketDetails() != null && !other.getS3BucketDetails().equals(this.getS3BucketDetails())) {
            return false;
        }
        if (other.getInstanceDetails() == null ^ this.getInstanceDetails() == null) {
            return false;
        }
        if (other.getInstanceDetails() != null && !other.getInstanceDetails().equals(this.getInstanceDetails())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        return other.getResourceType() == null || other.getResourceType().equals(this.getResourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessKeyDetails() == null ? 0 : this.getAccessKeyDetails().hashCode());
        hashCode = 31 * hashCode + (this.getS3BucketDetails() == null ? 0 : this.getS3BucketDetails().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceDetails() == null ? 0 : this.getInstanceDetails().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

