/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataConnector;
import com.amazonaws.services.iottwinmaker.model.Scope;
import com.amazonaws.services.iottwinmaker.model.transform.FunctionResponseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FunctionResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> requiredProperties;
    private String scope;
    private DataConnector implementedBy;
    private Boolean isInherited;

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public void setRequiredProperties(Collection<String> requiredProperties) {
        if (requiredProperties == null) {
            this.requiredProperties = null;
            return;
        }
        this.requiredProperties = new ArrayList<String>(requiredProperties);
    }

    public FunctionResponse withRequiredProperties(String ... requiredProperties) {
        if (this.requiredProperties == null) {
            this.setRequiredProperties(new ArrayList<String>(requiredProperties.length));
        }
        for (String ele : requiredProperties) {
            this.requiredProperties.add(ele);
        }
        return this;
    }

    public FunctionResponse withRequiredProperties(Collection<String> requiredProperties) {
        this.setRequiredProperties(requiredProperties);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public FunctionResponse withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public FunctionResponse withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public void setImplementedBy(DataConnector implementedBy) {
        this.implementedBy = implementedBy;
    }

    public DataConnector getImplementedBy() {
        return this.implementedBy;
    }

    public FunctionResponse withImplementedBy(DataConnector implementedBy) {
        this.setImplementedBy(implementedBy);
        return this;
    }

    public void setIsInherited(Boolean isInherited) {
        this.isInherited = isInherited;
    }

    public Boolean getIsInherited() {
        return this.isInherited;
    }

    public FunctionResponse withIsInherited(Boolean isInherited) {
        this.setIsInherited(isInherited);
        return this;
    }

    public Boolean isInherited() {
        return this.isInherited;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRequiredProperties() != null) {
            sb.append("RequiredProperties: ").append(this.getRequiredProperties()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getImplementedBy() != null) {
            sb.append("ImplementedBy: ").append(this.getImplementedBy()).append(",");
        }
        if (this.getIsInherited() != null) {
            sb.append("IsInherited: ").append(this.getIsInherited());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionResponse)) {
            return false;
        }
        FunctionResponse other = (FunctionResponse)obj;
        if (other.getRequiredProperties() == null ^ this.getRequiredProperties() == null) {
            return false;
        }
        if (other.getRequiredProperties() != null && !other.getRequiredProperties().equals(this.getRequiredProperties())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getImplementedBy() == null ^ this.getImplementedBy() == null) {
            return false;
        }
        if (other.getImplementedBy() != null && !other.getImplementedBy().equals(this.getImplementedBy())) {
            return false;
        }
        if (other.getIsInherited() == null ^ this.getIsInherited() == null) {
            return false;
        }
        return other.getIsInherited() == null || other.getIsInherited().equals(this.getIsInherited());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRequiredProperties() == null ? 0 : this.getRequiredProperties().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getImplementedBy() == null ? 0 : this.getImplementedBy().hashCode());
        hashCode = 31 * hashCode + (this.getIsInherited() == null ? 0 : this.getIsInherited().hashCode());
        return hashCode;
    }

    public FunctionResponse clone() {
        try {
            return (FunctionResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

