/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.LogLevel;
import com.amazonaws.services.iotwireless.model.WirelessDeviceEventLogOption;
import com.amazonaws.services.iotwireless.model.WirelessDeviceType;
import com.amazonaws.services.iotwireless.model.transform.WirelessDeviceLogOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WirelessDeviceLogOption
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String logLevel;
    private List<WirelessDeviceEventLogOption> events;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public WirelessDeviceLogOption withType(String type) {
        this.setType(type);
        return this;
    }

    public WirelessDeviceLogOption withType(WirelessDeviceType type) {
        this.type = type.toString();
        return this;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public WirelessDeviceLogOption withLogLevel(String logLevel) {
        this.setLogLevel(logLevel);
        return this;
    }

    public WirelessDeviceLogOption withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel.toString();
        return this;
    }

    public List<WirelessDeviceEventLogOption> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<WirelessDeviceEventLogOption> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<WirelessDeviceEventLogOption>(events);
    }

    public WirelessDeviceLogOption withEvents(WirelessDeviceEventLogOption ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<WirelessDeviceEventLogOption>(events.length));
        }
        for (WirelessDeviceEventLogOption ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public WirelessDeviceLogOption withEvents(Collection<WirelessDeviceEventLogOption> events) {
        this.setEvents(events);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLogLevel() != null) {
            sb.append("LogLevel: ").append(this.getLogLevel()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessDeviceLogOption)) {
            return false;
        }
        WirelessDeviceLogOption other = (WirelessDeviceLogOption)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLogLevel() == null ^ this.getLogLevel() == null) {
            return false;
        }
        if (other.getLogLevel() != null && !other.getLogLevel().equals(this.getLogLevel())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLogLevel() == null ? 0 : this.getLogLevel().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public WirelessDeviceLogOption clone() {
        try {
            return (WirelessDeviceLogOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WirelessDeviceLogOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

