/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafka.model.KafkaVersion;

@SdkInternalApi
public class KafkaVersionMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final KafkaVersionMarshaller instance = new KafkaVersionMarshaller();

    public static KafkaVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(KafkaVersion kafkaVersion, ProtocolMarshaller protocolMarshaller) {
        if (kafkaVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kafkaVersion.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)kafkaVersion.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

