/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafkaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kafkaconnect.model.S3LogDelivery;

@SdkInternalApi
public class S3LogDeliveryMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3LogDeliveryMarshaller instance = new S3LogDeliveryMarshaller();

    public static S3LogDeliveryMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3LogDelivery s3LogDelivery, ProtocolMarshaller protocolMarshaller) {
        if (s3LogDelivery == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3LogDelivery.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3LogDelivery.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)s3LogDelivery.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

