/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.location.model.CalculateRouteMatrixSummary;
import com.amazonaws.services.location.model.RouteMatrixEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CalculateRouteMatrixResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<List<RouteMatrixEntry>> routeMatrix;
    private List<List<Double>> snappedDeparturePositions;
    private List<List<Double>> snappedDestinationPositions;
    private CalculateRouteMatrixSummary summary;

    public List<List<RouteMatrixEntry>> getRouteMatrix() {
        return this.routeMatrix;
    }

    public void setRouteMatrix(Collection<List<RouteMatrixEntry>> routeMatrix) {
        if (routeMatrix == null) {
            this.routeMatrix = null;
            return;
        }
        this.routeMatrix = new ArrayList<List<RouteMatrixEntry>>(routeMatrix);
    }

    public CalculateRouteMatrixResult withRouteMatrix(List<RouteMatrixEntry> ... routeMatrix) {
        if (this.routeMatrix == null) {
            this.setRouteMatrix(new ArrayList<List<RouteMatrixEntry>>(routeMatrix.length));
        }
        for (List<RouteMatrixEntry> ele : routeMatrix) {
            this.routeMatrix.add(ele);
        }
        return this;
    }

    public CalculateRouteMatrixResult withRouteMatrix(Collection<List<RouteMatrixEntry>> routeMatrix) {
        this.setRouteMatrix(routeMatrix);
        return this;
    }

    public List<List<Double>> getSnappedDeparturePositions() {
        return this.snappedDeparturePositions;
    }

    public void setSnappedDeparturePositions(Collection<List<Double>> snappedDeparturePositions) {
        if (snappedDeparturePositions == null) {
            this.snappedDeparturePositions = null;
            return;
        }
        this.snappedDeparturePositions = new ArrayList<List<Double>>(snappedDeparturePositions);
    }

    public CalculateRouteMatrixResult withSnappedDeparturePositions(List<Double> ... snappedDeparturePositions) {
        if (this.snappedDeparturePositions == null) {
            this.setSnappedDeparturePositions(new ArrayList<List<Double>>(snappedDeparturePositions.length));
        }
        for (List<Double> ele : snappedDeparturePositions) {
            this.snappedDeparturePositions.add(ele);
        }
        return this;
    }

    public CalculateRouteMatrixResult withSnappedDeparturePositions(Collection<List<Double>> snappedDeparturePositions) {
        this.setSnappedDeparturePositions(snappedDeparturePositions);
        return this;
    }

    public List<List<Double>> getSnappedDestinationPositions() {
        return this.snappedDestinationPositions;
    }

    public void setSnappedDestinationPositions(Collection<List<Double>> snappedDestinationPositions) {
        if (snappedDestinationPositions == null) {
            this.snappedDestinationPositions = null;
            return;
        }
        this.snappedDestinationPositions = new ArrayList<List<Double>>(snappedDestinationPositions);
    }

    public CalculateRouteMatrixResult withSnappedDestinationPositions(List<Double> ... snappedDestinationPositions) {
        if (this.snappedDestinationPositions == null) {
            this.setSnappedDestinationPositions(new ArrayList<List<Double>>(snappedDestinationPositions.length));
        }
        for (List<Double> ele : snappedDestinationPositions) {
            this.snappedDestinationPositions.add(ele);
        }
        return this;
    }

    public CalculateRouteMatrixResult withSnappedDestinationPositions(Collection<List<Double>> snappedDestinationPositions) {
        this.setSnappedDestinationPositions(snappedDestinationPositions);
        return this;
    }

    public void setSummary(CalculateRouteMatrixSummary summary) {
        this.summary = summary;
    }

    public CalculateRouteMatrixSummary getSummary() {
        return this.summary;
    }

    public CalculateRouteMatrixResult withSummary(CalculateRouteMatrixSummary summary) {
        this.setSummary(summary);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRouteMatrix() != null) {
            sb.append("RouteMatrix: ").append(this.getRouteMatrix()).append(",");
        }
        if (this.getSnappedDeparturePositions() != null) {
            sb.append("SnappedDeparturePositions: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSnappedDestinationPositions() != null) {
            sb.append("SnappedDestinationPositions: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixResult)) {
            return false;
        }
        CalculateRouteMatrixResult other = (CalculateRouteMatrixResult)obj;
        if (other.getRouteMatrix() == null ^ this.getRouteMatrix() == null) {
            return false;
        }
        if (other.getRouteMatrix() != null && !other.getRouteMatrix().equals(this.getRouteMatrix())) {
            return false;
        }
        if (other.getSnappedDeparturePositions() == null ^ this.getSnappedDeparturePositions() == null) {
            return false;
        }
        if (other.getSnappedDeparturePositions() != null && !other.getSnappedDeparturePositions().equals(this.getSnappedDeparturePositions())) {
            return false;
        }
        if (other.getSnappedDestinationPositions() == null ^ this.getSnappedDestinationPositions() == null) {
            return false;
        }
        if (other.getSnappedDestinationPositions() != null && !other.getSnappedDestinationPositions().equals(this.getSnappedDestinationPositions())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        return other.getSummary() == null || other.getSummary().equals(this.getSummary());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRouteMatrix() == null ? 0 : this.getRouteMatrix().hashCode());
        hashCode = 31 * hashCode + (this.getSnappedDeparturePositions() == null ? 0 : this.getSnappedDeparturePositions().hashCode());
        hashCode = 31 * hashCode + (this.getSnappedDestinationPositions() == null ? 0 : this.getSnappedDestinationPositions().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        return hashCode;
    }

    public CalculateRouteMatrixResult clone() {
        try {
            return (CalculateRouteMatrixResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

