/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.ForecastedEvent;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ForecastedEventMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventId").build();
    private static final MarshallingInfo<String> GEOFENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeofenceId").build();
    private static final MarshallingInfo<Boolean> ISDEVICEINGEOFENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsDeviceInGeofence").build();
    private static final MarshallingInfo<Double> NEARESTDISTANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NearestDistance").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventType").build();
    private static final MarshallingInfo<Date> FORECASTEDBREACHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastedBreachTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Map> GEOFENCEPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeofenceProperties").build();
    private static final ForecastedEventMarshaller instance = new ForecastedEventMarshaller();

    public static ForecastedEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(ForecastedEvent forecastedEvent, ProtocolMarshaller protocolMarshaller) {
        if (forecastedEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)forecastedEvent.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)forecastedEvent.getGeofenceId(), GEOFENCEID_BINDING);
            protocolMarshaller.marshall((Object)forecastedEvent.getIsDeviceInGeofence(), ISDEVICEINGEOFENCE_BINDING);
            protocolMarshaller.marshall((Object)forecastedEvent.getNearestDistance(), NEARESTDISTANCE_BINDING);
            protocolMarshaller.marshall((Object)forecastedEvent.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)forecastedEvent.getForecastedBreachTime(), FORECASTEDBREACHTIME_BINDING);
            protocolMarshaller.marshall(forecastedEvent.getGeofenceProperties(), GEOFENCEPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

