/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediastore.AWSMediaStoreAsync;
import com.amazonaws.services.mediastore.AWSMediaStoreAsyncClientBuilder;
import com.amazonaws.services.mediastore.AWSMediaStoreClient;
import com.amazonaws.services.mediastore.model.CreateContainerRequest;
import com.amazonaws.services.mediastore.model.CreateContainerResult;
import com.amazonaws.services.mediastore.model.DeleteContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteContainerPolicyResult;
import com.amazonaws.services.mediastore.model.DeleteContainerRequest;
import com.amazonaws.services.mediastore.model.DeleteContainerResult;
import com.amazonaws.services.mediastore.model.DeleteCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteCorsPolicyResult;
import com.amazonaws.services.mediastore.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.DeleteMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteMetricPolicyResult;
import com.amazonaws.services.mediastore.model.DescribeContainerRequest;
import com.amazonaws.services.mediastore.model.DescribeContainerResult;
import com.amazonaws.services.mediastore.model.GetContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.GetContainerPolicyResult;
import com.amazonaws.services.mediastore.model.GetCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.GetCorsPolicyResult;
import com.amazonaws.services.mediastore.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.GetLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.GetMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.GetMetricPolicyResult;
import com.amazonaws.services.mediastore.model.ListContainersRequest;
import com.amazonaws.services.mediastore.model.ListContainersResult;
import com.amazonaws.services.mediastore.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediastore.model.ListTagsForResourceResult;
import com.amazonaws.services.mediastore.model.PutContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.PutContainerPolicyResult;
import com.amazonaws.services.mediastore.model.PutCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.PutCorsPolicyResult;
import com.amazonaws.services.mediastore.model.PutLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.PutLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.PutMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.PutMetricPolicyResult;
import com.amazonaws.services.mediastore.model.StartAccessLoggingRequest;
import com.amazonaws.services.mediastore.model.StartAccessLoggingResult;
import com.amazonaws.services.mediastore.model.StopAccessLoggingRequest;
import com.amazonaws.services.mediastore.model.StopAccessLoggingResult;
import com.amazonaws.services.mediastore.model.TagResourceRequest;
import com.amazonaws.services.mediastore.model.TagResourceResult;
import com.amazonaws.services.mediastore.model.UntagResourceRequest;
import com.amazonaws.services.mediastore.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaStoreAsyncClient
extends AWSMediaStoreClient
implements AWSMediaStoreAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaStoreAsyncClientBuilder asyncBuilder() {
        return AWSMediaStoreAsyncClientBuilder.standard();
    }

    AWSMediaStoreAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaStoreAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateContainerResult> createContainerAsync(CreateContainerRequest request) {
        return this.createContainerAsync(request, null);
    }

    @Override
    public Future<CreateContainerResult> createContainerAsync(CreateContainerRequest request, final AsyncHandler<CreateContainerRequest, CreateContainerResult> asyncHandler) {
        final CreateContainerRequest finalRequest = (CreateContainerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateContainerResult>(){

            @Override
            public CreateContainerResult call() throws Exception {
                CreateContainerResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeCreateContainer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteContainerResult> deleteContainerAsync(DeleteContainerRequest request) {
        return this.deleteContainerAsync(request, null);
    }

    @Override
    public Future<DeleteContainerResult> deleteContainerAsync(DeleteContainerRequest request, final AsyncHandler<DeleteContainerRequest, DeleteContainerResult> asyncHandler) {
        final DeleteContainerRequest finalRequest = (DeleteContainerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteContainerResult>(){

            @Override
            public DeleteContainerResult call() throws Exception {
                DeleteContainerResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDeleteContainer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteContainerPolicyResult> deleteContainerPolicyAsync(DeleteContainerPolicyRequest request) {
        return this.deleteContainerPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteContainerPolicyResult> deleteContainerPolicyAsync(DeleteContainerPolicyRequest request, final AsyncHandler<DeleteContainerPolicyRequest, DeleteContainerPolicyResult> asyncHandler) {
        final DeleteContainerPolicyRequest finalRequest = (DeleteContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteContainerPolicyResult>(){

            @Override
            public DeleteContainerPolicyResult call() throws Exception {
                DeleteContainerPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDeleteContainerPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCorsPolicyResult> deleteCorsPolicyAsync(DeleteCorsPolicyRequest request) {
        return this.deleteCorsPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteCorsPolicyResult> deleteCorsPolicyAsync(DeleteCorsPolicyRequest request, final AsyncHandler<DeleteCorsPolicyRequest, DeleteCorsPolicyResult> asyncHandler) {
        final DeleteCorsPolicyRequest finalRequest = (DeleteCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCorsPolicyResult>(){

            @Override
            public DeleteCorsPolicyResult call() throws Exception {
                DeleteCorsPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDeleteCorsPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request) {
        return this.deleteLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<DeleteLifecyclePolicyResult> deleteLifecyclePolicyAsync(DeleteLifecyclePolicyRequest request, final AsyncHandler<DeleteLifecyclePolicyRequest, DeleteLifecyclePolicyResult> asyncHandler) {
        final DeleteLifecyclePolicyRequest finalRequest = (DeleteLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLifecyclePolicyResult>(){

            @Override
            public DeleteLifecyclePolicyResult call() throws Exception {
                DeleteLifecyclePolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDeleteLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMetricPolicyResult> deleteMetricPolicyAsync(DeleteMetricPolicyRequest request) {
        return this.deleteMetricPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteMetricPolicyResult> deleteMetricPolicyAsync(DeleteMetricPolicyRequest request, final AsyncHandler<DeleteMetricPolicyRequest, DeleteMetricPolicyResult> asyncHandler) {
        final DeleteMetricPolicyRequest finalRequest = (DeleteMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMetricPolicyResult>(){

            @Override
            public DeleteMetricPolicyResult call() throws Exception {
                DeleteMetricPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDeleteMetricPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeContainerResult> describeContainerAsync(DescribeContainerRequest request) {
        return this.describeContainerAsync(request, null);
    }

    @Override
    public Future<DescribeContainerResult> describeContainerAsync(DescribeContainerRequest request, final AsyncHandler<DescribeContainerRequest, DescribeContainerResult> asyncHandler) {
        final DescribeContainerRequest finalRequest = (DescribeContainerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeContainerResult>(){

            @Override
            public DescribeContainerResult call() throws Exception {
                DescribeContainerResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeDescribeContainer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContainerPolicyResult> getContainerPolicyAsync(GetContainerPolicyRequest request) {
        return this.getContainerPolicyAsync(request, null);
    }

    @Override
    public Future<GetContainerPolicyResult> getContainerPolicyAsync(GetContainerPolicyRequest request, final AsyncHandler<GetContainerPolicyRequest, GetContainerPolicyResult> asyncHandler) {
        final GetContainerPolicyRequest finalRequest = (GetContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContainerPolicyResult>(){

            @Override
            public GetContainerPolicyResult call() throws Exception {
                GetContainerPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeGetContainerPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCorsPolicyResult> getCorsPolicyAsync(GetCorsPolicyRequest request) {
        return this.getCorsPolicyAsync(request, null);
    }

    @Override
    public Future<GetCorsPolicyResult> getCorsPolicyAsync(GetCorsPolicyRequest request, final AsyncHandler<GetCorsPolicyRequest, GetCorsPolicyResult> asyncHandler) {
        final GetCorsPolicyRequest finalRequest = (GetCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCorsPolicyResult>(){

            @Override
            public GetCorsPolicyResult call() throws Exception {
                GetCorsPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeGetCorsPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request) {
        return this.getLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<GetLifecyclePolicyResult> getLifecyclePolicyAsync(GetLifecyclePolicyRequest request, final AsyncHandler<GetLifecyclePolicyRequest, GetLifecyclePolicyResult> asyncHandler) {
        final GetLifecyclePolicyRequest finalRequest = (GetLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLifecyclePolicyResult>(){

            @Override
            public GetLifecyclePolicyResult call() throws Exception {
                GetLifecyclePolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeGetLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricPolicyResult> getMetricPolicyAsync(GetMetricPolicyRequest request) {
        return this.getMetricPolicyAsync(request, null);
    }

    @Override
    public Future<GetMetricPolicyResult> getMetricPolicyAsync(GetMetricPolicyRequest request, final AsyncHandler<GetMetricPolicyRequest, GetMetricPolicyResult> asyncHandler) {
        final GetMetricPolicyRequest finalRequest = (GetMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricPolicyResult>(){

            @Override
            public GetMetricPolicyResult call() throws Exception {
                GetMetricPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeGetMetricPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContainersResult> listContainersAsync(ListContainersRequest request) {
        return this.listContainersAsync(request, null);
    }

    @Override
    public Future<ListContainersResult> listContainersAsync(ListContainersRequest request, final AsyncHandler<ListContainersRequest, ListContainersResult> asyncHandler) {
        final ListContainersRequest finalRequest = (ListContainersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContainersResult>(){

            @Override
            public ListContainersResult call() throws Exception {
                ListContainersResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeListContainers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutContainerPolicyResult> putContainerPolicyAsync(PutContainerPolicyRequest request) {
        return this.putContainerPolicyAsync(request, null);
    }

    @Override
    public Future<PutContainerPolicyResult> putContainerPolicyAsync(PutContainerPolicyRequest request, final AsyncHandler<PutContainerPolicyRequest, PutContainerPolicyResult> asyncHandler) {
        final PutContainerPolicyRequest finalRequest = (PutContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutContainerPolicyResult>(){

            @Override
            public PutContainerPolicyResult call() throws Exception {
                PutContainerPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executePutContainerPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutCorsPolicyResult> putCorsPolicyAsync(PutCorsPolicyRequest request) {
        return this.putCorsPolicyAsync(request, null);
    }

    @Override
    public Future<PutCorsPolicyResult> putCorsPolicyAsync(PutCorsPolicyRequest request, final AsyncHandler<PutCorsPolicyRequest, PutCorsPolicyResult> asyncHandler) {
        final PutCorsPolicyRequest finalRequest = (PutCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutCorsPolicyResult>(){

            @Override
            public PutCorsPolicyResult call() throws Exception {
                PutCorsPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executePutCorsPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLifecyclePolicyResult> putLifecyclePolicyAsync(PutLifecyclePolicyRequest request) {
        return this.putLifecyclePolicyAsync(request, null);
    }

    @Override
    public Future<PutLifecyclePolicyResult> putLifecyclePolicyAsync(PutLifecyclePolicyRequest request, final AsyncHandler<PutLifecyclePolicyRequest, PutLifecyclePolicyResult> asyncHandler) {
        final PutLifecyclePolicyRequest finalRequest = (PutLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLifecyclePolicyResult>(){

            @Override
            public PutLifecyclePolicyResult call() throws Exception {
                PutLifecyclePolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executePutLifecyclePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricPolicyResult> putMetricPolicyAsync(PutMetricPolicyRequest request) {
        return this.putMetricPolicyAsync(request, null);
    }

    @Override
    public Future<PutMetricPolicyResult> putMetricPolicyAsync(PutMetricPolicyRequest request, final AsyncHandler<PutMetricPolicyRequest, PutMetricPolicyResult> asyncHandler) {
        final PutMetricPolicyRequest finalRequest = (PutMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricPolicyResult>(){

            @Override
            public PutMetricPolicyResult call() throws Exception {
                PutMetricPolicyResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executePutMetricPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartAccessLoggingResult> startAccessLoggingAsync(StartAccessLoggingRequest request) {
        return this.startAccessLoggingAsync(request, null);
    }

    @Override
    public Future<StartAccessLoggingResult> startAccessLoggingAsync(StartAccessLoggingRequest request, final AsyncHandler<StartAccessLoggingRequest, StartAccessLoggingResult> asyncHandler) {
        final StartAccessLoggingRequest finalRequest = (StartAccessLoggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartAccessLoggingResult>(){

            @Override
            public StartAccessLoggingResult call() throws Exception {
                StartAccessLoggingResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeStartAccessLogging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopAccessLoggingResult> stopAccessLoggingAsync(StopAccessLoggingRequest request) {
        return this.stopAccessLoggingAsync(request, null);
    }

    @Override
    public Future<StopAccessLoggingResult> stopAccessLoggingAsync(StopAccessLoggingRequest request, final AsyncHandler<StopAccessLoggingRequest, StopAccessLoggingResult> asyncHandler) {
        final StopAccessLoggingRequest finalRequest = (StopAccessLoggingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopAccessLoggingResult>(){

            @Override
            public StopAccessLoggingResult call() throws Exception {
                StopAccessLoggingResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeStopAccessLogging(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaStoreAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

