/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CrossDatasetTypes;
import com.amazonaws.services.quicksight.model.Filter;
import com.amazonaws.services.quicksight.model.FilterScopeConfiguration;
import com.amazonaws.services.quicksight.model.WidgetStatus;
import com.amazonaws.services.quicksight.model.transform.FilterGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String filterGroupId;
    private List<Filter> filters;
    private FilterScopeConfiguration scopeConfiguration;
    private String status;
    private String crossDataset;

    public void setFilterGroupId(String filterGroupId) {
        this.filterGroupId = filterGroupId;
    }

    public String getFilterGroupId() {
        return this.filterGroupId;
    }

    public FilterGroup withFilterGroupId(String filterGroupId) {
        this.setFilterGroupId(filterGroupId);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public FilterGroup withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public FilterGroup withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setScopeConfiguration(FilterScopeConfiguration scopeConfiguration) {
        this.scopeConfiguration = scopeConfiguration;
    }

    public FilterScopeConfiguration getScopeConfiguration() {
        return this.scopeConfiguration;
    }

    public FilterGroup withScopeConfiguration(FilterScopeConfiguration scopeConfiguration) {
        this.setScopeConfiguration(scopeConfiguration);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public FilterGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public FilterGroup withStatus(WidgetStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCrossDataset(String crossDataset) {
        this.crossDataset = crossDataset;
    }

    public String getCrossDataset() {
        return this.crossDataset;
    }

    public FilterGroup withCrossDataset(String crossDataset) {
        this.setCrossDataset(crossDataset);
        return this;
    }

    public FilterGroup withCrossDataset(CrossDatasetTypes crossDataset) {
        this.crossDataset = crossDataset.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterGroupId() != null) {
            sb.append("FilterGroupId: ").append(this.getFilterGroupId()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getScopeConfiguration() != null) {
            sb.append("ScopeConfiguration: ").append(this.getScopeConfiguration()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCrossDataset() != null) {
            sb.append("CrossDataset: ").append(this.getCrossDataset());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterGroup)) {
            return false;
        }
        FilterGroup other = (FilterGroup)obj;
        if (other.getFilterGroupId() == null ^ this.getFilterGroupId() == null) {
            return false;
        }
        if (other.getFilterGroupId() != null && !other.getFilterGroupId().equals(this.getFilterGroupId())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getScopeConfiguration() == null ^ this.getScopeConfiguration() == null) {
            return false;
        }
        if (other.getScopeConfiguration() != null && !other.getScopeConfiguration().equals(this.getScopeConfiguration())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCrossDataset() == null ^ this.getCrossDataset() == null) {
            return false;
        }
        return other.getCrossDataset() == null || other.getCrossDataset().equals(this.getCrossDataset());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterGroupId() == null ? 0 : this.getFilterGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getScopeConfiguration() == null ? 0 : this.getScopeConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCrossDataset() == null ? 0 : this.getCrossDataset().hashCode());
        return hashCode;
    }

    public FilterGroup clone() {
        try {
            return (FilterGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

