/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ResourceStatus;
import com.amazonaws.services.quicksight.model.ThemeConfiguration;
import com.amazonaws.services.quicksight.model.ThemeError;
import com.amazonaws.services.quicksight.model.transform.ThemeVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ThemeVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private Long versionNumber;
    private String arn;
    private String description;
    private String baseThemeId;
    private Date createdTime;
    private ThemeConfiguration configuration;
    private List<ThemeError> errors;
    private String status;

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public ThemeVersion withVersionNumber(Long versionNumber) {
        this.setVersionNumber(versionNumber);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ThemeVersion withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ThemeVersion withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setBaseThemeId(String baseThemeId) {
        this.baseThemeId = baseThemeId;
    }

    public String getBaseThemeId() {
        return this.baseThemeId;
    }

    public ThemeVersion withBaseThemeId(String baseThemeId) {
        this.setBaseThemeId(baseThemeId);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public ThemeVersion withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setConfiguration(ThemeConfiguration configuration) {
        this.configuration = configuration;
    }

    public ThemeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ThemeVersion withConfiguration(ThemeConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<ThemeError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<ThemeError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<ThemeError>(errors);
    }

    public ThemeVersion withErrors(ThemeError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<ThemeError>(errors.length));
        }
        for (ThemeError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public ThemeVersion withErrors(Collection<ThemeError> errors) {
        this.setErrors(errors);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ThemeVersion withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ThemeVersion withStatus(ResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersionNumber() != null) {
            sb.append("VersionNumber: ").append(this.getVersionNumber()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getBaseThemeId() != null) {
            sb.append("BaseThemeId: ").append(this.getBaseThemeId()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeVersion)) {
            return false;
        }
        ThemeVersion other = (ThemeVersion)obj;
        if (other.getVersionNumber() == null ^ this.getVersionNumber() == null) {
            return false;
        }
        if (other.getVersionNumber() != null && !other.getVersionNumber().equals(this.getVersionNumber())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getBaseThemeId() == null ^ this.getBaseThemeId() == null) {
            return false;
        }
        if (other.getBaseThemeId() != null && !other.getBaseThemeId().equals(this.getBaseThemeId())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersionNumber() == null ? 0 : this.getVersionNumber().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBaseThemeId() == null ? 0 : this.getBaseThemeId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public ThemeVersion clone() {
        try {
            return (ThemeVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThemeVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

