/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnTagName;
import com.amazonaws.services.quicksight.model.transform.UntagColumnOperationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UntagColumnOperation
implements Serializable,
Cloneable,
StructuredPojo {
    private String columnName;
    private List<String> tagNames;

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public UntagColumnOperation withColumnName(String columnName) {
        this.setColumnName(columnName);
        return this;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    public void setTagNames(Collection<String> tagNames) {
        if (tagNames == null) {
            this.tagNames = null;
            return;
        }
        this.tagNames = new ArrayList<String>(tagNames);
    }

    public UntagColumnOperation withTagNames(String ... tagNames) {
        if (this.tagNames == null) {
            this.setTagNames(new ArrayList<String>(tagNames.length));
        }
        for (String ele : tagNames) {
            this.tagNames.add(ele);
        }
        return this;
    }

    public UntagColumnOperation withTagNames(Collection<String> tagNames) {
        this.setTagNames(tagNames);
        return this;
    }

    public UntagColumnOperation withTagNames(ColumnTagName ... tagNames) {
        ArrayList<String> tagNamesCopy = new ArrayList<String>(tagNames.length);
        for (ColumnTagName value : tagNames) {
            tagNamesCopy.add(value.toString());
        }
        if (this.getTagNames() == null) {
            this.setTagNames(tagNamesCopy);
        } else {
            this.getTagNames().addAll(tagNamesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumnName() != null) {
            sb.append("ColumnName: ").append(this.getColumnName()).append(",");
        }
        if (this.getTagNames() != null) {
            sb.append("TagNames: ").append(this.getTagNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagColumnOperation)) {
            return false;
        }
        UntagColumnOperation other = (UntagColumnOperation)obj;
        if (other.getColumnName() == null ^ this.getColumnName() == null) {
            return false;
        }
        if (other.getColumnName() != null && !other.getColumnName().equals(this.getColumnName())) {
            return false;
        }
        if (other.getTagNames() == null ^ this.getTagNames() == null) {
            return false;
        }
        return other.getTagNames() == null || other.getTagNames().equals(this.getTagNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumnName() == null ? 0 : this.getColumnName().hashCode());
        hashCode = 31 * hashCode + (this.getTagNames() == null ? 0 : this.getTagNames().hashCode());
        return hashCode;
    }

    public UntagColumnOperation clone() {
        try {
            return (UntagColumnOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UntagColumnOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

