/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataPathColor;
import com.amazonaws.services.quicksight.model.transform.VisualPaletteMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisualPalette
implements Serializable,
Cloneable,
StructuredPojo {
    private String chartColor;
    private List<DataPathColor> colorMap;

    public void setChartColor(String chartColor) {
        this.chartColor = chartColor;
    }

    public String getChartColor() {
        return this.chartColor;
    }

    public VisualPalette withChartColor(String chartColor) {
        this.setChartColor(chartColor);
        return this;
    }

    public List<DataPathColor> getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(Collection<DataPathColor> colorMap) {
        if (colorMap == null) {
            this.colorMap = null;
            return;
        }
        this.colorMap = new ArrayList<DataPathColor>(colorMap);
    }

    public VisualPalette withColorMap(DataPathColor ... colorMap) {
        if (this.colorMap == null) {
            this.setColorMap(new ArrayList<DataPathColor>(colorMap.length));
        }
        for (DataPathColor ele : colorMap) {
            this.colorMap.add(ele);
        }
        return this;
    }

    public VisualPalette withColorMap(Collection<DataPathColor> colorMap) {
        this.setColorMap(colorMap);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChartColor() != null) {
            sb.append("ChartColor: ").append(this.getChartColor()).append(",");
        }
        if (this.getColorMap() != null) {
            sb.append("ColorMap: ").append(this.getColorMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualPalette)) {
            return false;
        }
        VisualPalette other = (VisualPalette)obj;
        if (other.getChartColor() == null ^ this.getChartColor() == null) {
            return false;
        }
        if (other.getChartColor() != null && !other.getChartColor().equals(this.getChartColor())) {
            return false;
        }
        if (other.getColorMap() == null ^ this.getColorMap() == null) {
            return false;
        }
        return other.getColorMap() == null || other.getColorMap().equals(this.getColorMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChartColor() == null ? 0 : this.getChartColor().hashCode());
        hashCode = 31 * hashCode + (this.getColorMap() == null ? 0 : this.getColorMap().hashCode());
        return hashCode;
    }

    public VisualPalette clone() {
        try {
            return (VisualPalette)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VisualPaletteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

