/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.HeatMapVisual;
import java.util.List;

@SdkInternalApi
public class HeatMapVisualMarshaller {
    private static final MarshallingInfo<String> VISUALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualId").build();
    private static final MarshallingInfo<StructuredPojo> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<StructuredPojo> SUBTITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subtitle").build();
    private static final MarshallingInfo<StructuredPojo> CHARTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChartConfiguration").build();
    private static final MarshallingInfo<List> COLUMNHIERARCHIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnHierarchies").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final HeatMapVisualMarshaller instance = new HeatMapVisualMarshaller();

    public static HeatMapVisualMarshaller getInstance() {
        return instance;
    }

    public void marshall(HeatMapVisual heatMapVisual, ProtocolMarshaller protocolMarshaller) {
        if (heatMapVisual == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)heatMapVisual.getVisualId(), VISUALID_BINDING);
            protocolMarshaller.marshall((Object)heatMapVisual.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)heatMapVisual.getSubtitle(), SUBTITLE_BINDING);
            protocolMarshaller.marshall((Object)heatMapVisual.getChartConfiguration(), CHARTCONFIGURATION_BINDING);
            protocolMarshaller.marshall(heatMapVisual.getColumnHierarchies(), COLUMNHIERARCHIES_BINDING);
            protocolMarshaller.marshall(heatMapVisual.getActions(), ACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

