/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.LogicalTable;
import java.util.List;

@SdkInternalApi
public class LogicalTableMarshaller {
    private static final MarshallingInfo<String> ALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alias").build();
    private static final MarshallingInfo<List> DATATRANSFORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTransforms").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final LogicalTableMarshaller instance = new LogicalTableMarshaller();

    public static LogicalTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(LogicalTable logicalTable, ProtocolMarshaller protocolMarshaller) {
        if (logicalTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)logicalTable.getAlias(), ALIAS_BINDING);
            protocolMarshaller.marshall(logicalTable.getDataTransforms(), DATATRANSFORMS_BINDING);
            protocolMarshaller.marshall((Object)logicalTable.getSource(), SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

