/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.EnableLoggingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableLoggingRequestMarshaller
implements Marshaller<Request<EnableLoggingRequest>, EnableLoggingRequest> {
    public Request<EnableLoggingRequest> marshall(EnableLoggingRequest enableLoggingRequest) {
        if (enableLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableLoggingRequest, "AmazonRedshift");
        request.addParameter("Action", "EnableLogging");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableLoggingRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)enableLoggingRequest.getClusterIdentifier()));
        }
        if (enableLoggingRequest.getBucketName() != null) {
            request.addParameter("BucketName", StringUtils.fromString((String)enableLoggingRequest.getBucketName()));
        }
        if (enableLoggingRequest.getS3KeyPrefix() != null) {
            request.addParameter("S3KeyPrefix", StringUtils.fromString((String)enableLoggingRequest.getS3KeyPrefix()));
        }
        if (enableLoggingRequest.getLogDestinationType() != null) {
            request.addParameter("LogDestinationType", StringUtils.fromString((String)enableLoggingRequest.getLogDestinationType()));
        }
        if (!enableLoggingRequest.getLogExports().isEmpty() || !((SdkInternalList)enableLoggingRequest.getLogExports()).isAutoConstruct()) {
            SdkInternalList logExportsList = (SdkInternalList)enableLoggingRequest.getLogExports();
            int logExportsListIndex = 1;
            for (String logExportsListValue : logExportsList) {
                if (logExportsListValue != null) {
                    request.addParameter("LogExports.member." + logExportsListIndex, StringUtils.fromString((String)logExportsListValue));
                }
                ++logExportsListIndex;
            }
        }
        return request;
    }
}

