/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.Parameter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyClusterParameterGroupRequest>, ModifyClusterParameterGroupRequest> {
    public Request<ModifyClusterParameterGroupRequest> marshall(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        if (modifyClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClusterParameterGroupRequest, "AmazonRedshift");
        request.addParameter("Action", "ModifyClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterParameterGroupRequest.getParameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)modifyClusterParameterGroupRequest.getParameterGroupName()));
        }
        if (!modifyClusterParameterGroupRequest.getParameters().isEmpty() || !((SdkInternalList)modifyClusterParameterGroupRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)modifyClusterParameterGroupRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue != null) {
                    if (parametersListValue.getParameterName() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString((String)parametersListValue.getParameterName()));
                    }
                    if (parametersListValue.getParameterValue() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                    }
                    if (parametersListValue.getDescription() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString((String)parametersListValue.getDescription()));
                    }
                    if (parametersListValue.getSource() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString((String)parametersListValue.getSource()));
                    }
                    if (parametersListValue.getDataType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString((String)parametersListValue.getDataType()));
                    }
                    if (parametersListValue.getAllowedValues() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString((String)parametersListValue.getAllowedValues()));
                    }
                    if (parametersListValue.getApplyType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString((String)parametersListValue.getApplyType()));
                    }
                    if (parametersListValue.getIsModifiable() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)parametersListValue.getIsModifiable()));
                    }
                    if (parametersListValue.getMinimumEngineVersion() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString((String)parametersListValue.getMinimumEngineVersion()));
                    }
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

