/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.repostspace;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.repostspace.AWSRepostspaceAsync;
import com.amazonaws.services.repostspace.AWSRepostspaceAsyncClientBuilder;
import com.amazonaws.services.repostspace.AWSRepostspaceClient;
import com.amazonaws.services.repostspace.model.CreateSpaceRequest;
import com.amazonaws.services.repostspace.model.CreateSpaceResult;
import com.amazonaws.services.repostspace.model.DeleteSpaceRequest;
import com.amazonaws.services.repostspace.model.DeleteSpaceResult;
import com.amazonaws.services.repostspace.model.DeregisterAdminRequest;
import com.amazonaws.services.repostspace.model.DeregisterAdminResult;
import com.amazonaws.services.repostspace.model.GetSpaceRequest;
import com.amazonaws.services.repostspace.model.GetSpaceResult;
import com.amazonaws.services.repostspace.model.ListSpacesRequest;
import com.amazonaws.services.repostspace.model.ListSpacesResult;
import com.amazonaws.services.repostspace.model.ListTagsForResourceRequest;
import com.amazonaws.services.repostspace.model.ListTagsForResourceResult;
import com.amazonaws.services.repostspace.model.RegisterAdminRequest;
import com.amazonaws.services.repostspace.model.RegisterAdminResult;
import com.amazonaws.services.repostspace.model.SendInvitesRequest;
import com.amazonaws.services.repostspace.model.SendInvitesResult;
import com.amazonaws.services.repostspace.model.TagResourceRequest;
import com.amazonaws.services.repostspace.model.TagResourceResult;
import com.amazonaws.services.repostspace.model.UntagResourceRequest;
import com.amazonaws.services.repostspace.model.UntagResourceResult;
import com.amazonaws.services.repostspace.model.UpdateSpaceRequest;
import com.amazonaws.services.repostspace.model.UpdateSpaceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRepostspaceAsyncClient
extends AWSRepostspaceClient
implements AWSRepostspaceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRepostspaceAsyncClientBuilder asyncBuilder() {
        return AWSRepostspaceAsyncClientBuilder.standard();
    }

    AWSRepostspaceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSRepostspaceAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSpaceResult> createSpaceAsync(CreateSpaceRequest request) {
        return this.createSpaceAsync(request, null);
    }

    @Override
    public Future<CreateSpaceResult> createSpaceAsync(CreateSpaceRequest request, final AsyncHandler<CreateSpaceRequest, CreateSpaceResult> asyncHandler) {
        final CreateSpaceRequest finalRequest = (CreateSpaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSpaceResult>(){

            @Override
            public CreateSpaceResult call() throws Exception {
                CreateSpaceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeCreateSpace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSpaceResult> deleteSpaceAsync(DeleteSpaceRequest request) {
        return this.deleteSpaceAsync(request, null);
    }

    @Override
    public Future<DeleteSpaceResult> deleteSpaceAsync(DeleteSpaceRequest request, final AsyncHandler<DeleteSpaceRequest, DeleteSpaceResult> asyncHandler) {
        final DeleteSpaceRequest finalRequest = (DeleteSpaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSpaceResult>(){

            @Override
            public DeleteSpaceResult call() throws Exception {
                DeleteSpaceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeDeleteSpace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterAdminResult> deregisterAdminAsync(DeregisterAdminRequest request) {
        return this.deregisterAdminAsync(request, null);
    }

    @Override
    public Future<DeregisterAdminResult> deregisterAdminAsync(DeregisterAdminRequest request, final AsyncHandler<DeregisterAdminRequest, DeregisterAdminResult> asyncHandler) {
        final DeregisterAdminRequest finalRequest = (DeregisterAdminRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterAdminResult>(){

            @Override
            public DeregisterAdminResult call() throws Exception {
                DeregisterAdminResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeDeregisterAdmin(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSpaceResult> getSpaceAsync(GetSpaceRequest request) {
        return this.getSpaceAsync(request, null);
    }

    @Override
    public Future<GetSpaceResult> getSpaceAsync(GetSpaceRequest request, final AsyncHandler<GetSpaceRequest, GetSpaceResult> asyncHandler) {
        final GetSpaceRequest finalRequest = (GetSpaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSpaceResult>(){

            @Override
            public GetSpaceResult call() throws Exception {
                GetSpaceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeGetSpace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSpacesResult> listSpacesAsync(ListSpacesRequest request) {
        return this.listSpacesAsync(request, null);
    }

    @Override
    public Future<ListSpacesResult> listSpacesAsync(ListSpacesRequest request, final AsyncHandler<ListSpacesRequest, ListSpacesResult> asyncHandler) {
        final ListSpacesRequest finalRequest = (ListSpacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSpacesResult>(){

            @Override
            public ListSpacesResult call() throws Exception {
                ListSpacesResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeListSpaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterAdminResult> registerAdminAsync(RegisterAdminRequest request) {
        return this.registerAdminAsync(request, null);
    }

    @Override
    public Future<RegisterAdminResult> registerAdminAsync(RegisterAdminRequest request, final AsyncHandler<RegisterAdminRequest, RegisterAdminResult> asyncHandler) {
        final RegisterAdminRequest finalRequest = (RegisterAdminRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterAdminResult>(){

            @Override
            public RegisterAdminResult call() throws Exception {
                RegisterAdminResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeRegisterAdmin(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendInvitesResult> sendInvitesAsync(SendInvitesRequest request) {
        return this.sendInvitesAsync(request, null);
    }

    @Override
    public Future<SendInvitesResult> sendInvitesAsync(SendInvitesRequest request, final AsyncHandler<SendInvitesRequest, SendInvitesResult> asyncHandler) {
        final SendInvitesRequest finalRequest = (SendInvitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendInvitesResult>(){

            @Override
            public SendInvitesResult call() throws Exception {
                SendInvitesResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeSendInvites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSpaceResult> updateSpaceAsync(UpdateSpaceRequest request) {
        return this.updateSpaceAsync(request, null);
    }

    @Override
    public Future<UpdateSpaceResult> updateSpaceAsync(UpdateSpaceRequest request, final AsyncHandler<UpdateSpaceRequest, UpdateSpaceResult> asyncHandler) {
        final UpdateSpaceRequest finalRequest = (UpdateSpaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSpaceResult>(){

            @Override
            public UpdateSpaceResult call() throws Exception {
                UpdateSpaceResult result = null;
                try {
                    result = AWSRepostspaceAsyncClient.this.executeUpdateSpace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

