/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.transform.S3KeyOutputMarshaller;
import java.io.Serializable;

public class S3KeyOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Key;
    private String etag;

    public void setS3Key(String s3Key) {
        this.s3Key = s3Key;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public S3KeyOutput withS3Key(String s3Key) {
        this.setS3Key(s3Key);
        return this;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getEtag() {
        return this.etag;
    }

    public S3KeyOutput withEtag(String etag) {
        this.setEtag(etag);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Key() != null) {
            sb.append("S3Key: ").append(this.getS3Key()).append(",");
        }
        if (this.getEtag() != null) {
            sb.append("Etag: ").append(this.getEtag());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyOutput)) {
            return false;
        }
        S3KeyOutput other = (S3KeyOutput)obj;
        if (other.getS3Key() == null ^ this.getS3Key() == null) {
            return false;
        }
        if (other.getS3Key() != null && !other.getS3Key().equals(this.getS3Key())) {
            return false;
        }
        if (other.getEtag() == null ^ this.getEtag() == null) {
            return false;
        }
        return other.getEtag() == null || other.getEtag().equals(this.getEtag());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Key() == null ? 0 : this.getS3Key().hashCode());
        hashCode = 31 * hashCode + (this.getEtag() == null ? 0 : this.getEtag().hashCode());
        return hashCode;
    }

    public S3KeyOutput clone() {
        try {
            return (S3KeyOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3KeyOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

