/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateStorageLensGroupRequest;
import com.amazonaws.services.s3control.model.MatchObjectAge;
import com.amazonaws.services.s3control.model.MatchObjectSize;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.services.s3control.model.StorageLensGroup;
import com.amazonaws.services.s3control.model.StorageLensGroupAndOperator;
import com.amazonaws.services.s3control.model.StorageLensGroupFilter;
import com.amazonaws.services.s3control.model.StorageLensGroupOrOperator;
import com.amazonaws.services.s3control.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class CreateStorageLensGroupRequestMarshaller
implements Marshaller<Request<CreateStorageLensGroupRequest>, CreateStorageLensGroupRequest> {
    public Request<CreateStorageLensGroupRequest> marshall(CreateStorageLensGroupRequest createStorageLensGroupRequest) {
        if (createStorageLensGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStorageLensGroupRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStorageLensGroupRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createStorageLensGroupRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/storagelensgroup";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateStorageLensGroupRequest");
            if (createStorageLensGroupRequest != null) {
                List<Tag> createStorageLensGroupRequestTagsList;
                StorageLensGroup storageLensGroup = createStorageLensGroupRequest.getStorageLensGroup();
                if (storageLensGroup != null) {
                    StorageLensGroupFilter filter;
                    xmlWriter.startElement("StorageLensGroup");
                    if (storageLensGroup.getName() != null) {
                        xmlWriter.startElement("Name").value(storageLensGroup.getName()).endElement();
                    }
                    if ((filter = storageLensGroup.getFilter()) != null) {
                        StorageLensGroupOrOperator storageLensGroupOrOperator;
                        StorageLensGroupAndOperator storageLensGroupAndOperator;
                        MatchObjectSize matchObjectSize;
                        MatchObjectAge matchObjectAge;
                        List<S3Tag> list;
                        List<String> storageLensGroupFilterMatchAnySuffixList;
                        xmlWriter.startElement("Filter");
                        List<String> storageLensGroupFilterMatchAnyPrefixList = filter.getMatchAnyPrefix();
                        if (storageLensGroupFilterMatchAnyPrefixList != null) {
                            xmlWriter.startElement("MatchAnyPrefix");
                            for (String string : storageLensGroupFilterMatchAnyPrefixList) {
                                xmlWriter.startElement("Prefix");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((storageLensGroupFilterMatchAnySuffixList = filter.getMatchAnySuffix()) != null) {
                            xmlWriter.startElement("MatchAnySuffix");
                            for (String string : storageLensGroupFilterMatchAnySuffixList) {
                                xmlWriter.startElement("Suffix");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((list = filter.getMatchAnyTag()) != null) {
                            xmlWriter.startElement("MatchAnyTag");
                            for (S3Tag storageLensGroupFilterMatchAnyTagListValue : list) {
                                xmlWriter.startElement("Tag");
                                if (storageLensGroupFilterMatchAnyTagListValue.getKey() != null) {
                                    xmlWriter.startElement("Key").value(storageLensGroupFilterMatchAnyTagListValue.getKey()).endElement();
                                }
                                if (storageLensGroupFilterMatchAnyTagListValue.getValue() != null) {
                                    xmlWriter.startElement("Value").value(storageLensGroupFilterMatchAnyTagListValue.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((matchObjectAge = filter.getMatchObjectAge()) != null) {
                            xmlWriter.startElement("MatchObjectAge");
                            if (matchObjectAge.getDaysGreaterThan() != null) {
                                xmlWriter.startElement("DaysGreaterThan").value((Object)matchObjectAge.getDaysGreaterThan()).endElement();
                            }
                            if (matchObjectAge.getDaysLessThan() != null) {
                                xmlWriter.startElement("DaysLessThan").value((Object)matchObjectAge.getDaysLessThan()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((matchObjectSize = filter.getMatchObjectSize()) != null) {
                            xmlWriter.startElement("MatchObjectSize");
                            if (matchObjectSize.getBytesGreaterThan() != null) {
                                xmlWriter.startElement("BytesGreaterThan").value((Object)matchObjectSize.getBytesGreaterThan()).endElement();
                            }
                            if (matchObjectSize.getBytesLessThan() != null) {
                                xmlWriter.startElement("BytesLessThan").value((Object)matchObjectSize.getBytesLessThan()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((storageLensGroupAndOperator = filter.getAnd()) != null) {
                            MatchObjectSize matchObjectSize2;
                            MatchObjectAge matchObjectAge2;
                            List<S3Tag> list2;
                            Object storageLensGroupAndOperatorMatchAnySuffixList;
                            xmlWriter.startElement("And");
                            List<String> storageLensGroupAndOperatorMatchAnyPrefixList = storageLensGroupAndOperator.getMatchAnyPrefix();
                            if (storageLensGroupAndOperatorMatchAnyPrefixList != null) {
                                xmlWriter.startElement("MatchAnyPrefix");
                                for (String string : storageLensGroupAndOperatorMatchAnyPrefixList) {
                                    xmlWriter.startElement("Prefix");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((storageLensGroupAndOperatorMatchAnySuffixList = storageLensGroupAndOperator.getMatchAnySuffix()) != null) {
                                xmlWriter.startElement("MatchAnySuffix");
                                Iterator<String> iterator = storageLensGroupAndOperatorMatchAnySuffixList.iterator();
                                while (iterator.hasNext()) {
                                    String string = iterator.next();
                                    xmlWriter.startElement("Suffix");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((list2 = storageLensGroupAndOperator.getMatchAnyTag()) != null) {
                                xmlWriter.startElement("MatchAnyTag");
                                for (S3Tag storageLensGroupAndOperatorMatchAnyTagListValue : list2) {
                                    xmlWriter.startElement("Tag");
                                    if (storageLensGroupAndOperatorMatchAnyTagListValue.getKey() != null) {
                                        xmlWriter.startElement("Key").value(storageLensGroupAndOperatorMatchAnyTagListValue.getKey()).endElement();
                                    }
                                    if (storageLensGroupAndOperatorMatchAnyTagListValue.getValue() != null) {
                                        xmlWriter.startElement("Value").value(storageLensGroupAndOperatorMatchAnyTagListValue.getValue()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((matchObjectAge2 = storageLensGroupAndOperator.getMatchObjectAge()) != null) {
                                xmlWriter.startElement("MatchObjectAge");
                                if (matchObjectAge2.getDaysGreaterThan() != null) {
                                    xmlWriter.startElement("DaysGreaterThan").value((Object)matchObjectAge2.getDaysGreaterThan()).endElement();
                                }
                                if (matchObjectAge2.getDaysLessThan() != null) {
                                    xmlWriter.startElement("DaysLessThan").value((Object)matchObjectAge2.getDaysLessThan()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((matchObjectSize2 = storageLensGroupAndOperator.getMatchObjectSize()) != null) {
                                xmlWriter.startElement("MatchObjectSize");
                                if (matchObjectSize2.getBytesGreaterThan() != null) {
                                    xmlWriter.startElement("BytesGreaterThan").value((Object)matchObjectSize2.getBytesGreaterThan()).endElement();
                                }
                                if (matchObjectSize2.getBytesLessThan() != null) {
                                    xmlWriter.startElement("BytesLessThan").value((Object)matchObjectSize2.getBytesLessThan()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((storageLensGroupOrOperator = filter.getOr()) != null) {
                            MatchObjectSize matchObjectSize3;
                            MatchObjectAge matchObjectAge3;
                            List<S3Tag> list3;
                            List<String> storageLensGroupOrOperatorMatchAnySuffixList;
                            xmlWriter.startElement("Or");
                            List<String> storageLensGroupOrOperatorMatchAnyPrefixList = storageLensGroupOrOperator.getMatchAnyPrefix();
                            if (storageLensGroupOrOperatorMatchAnyPrefixList != null) {
                                xmlWriter.startElement("MatchAnyPrefix");
                                for (String string : storageLensGroupOrOperatorMatchAnyPrefixList) {
                                    xmlWriter.startElement("Prefix");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((storageLensGroupOrOperatorMatchAnySuffixList = storageLensGroupOrOperator.getMatchAnySuffix()) != null) {
                                xmlWriter.startElement("MatchAnySuffix");
                                for (String string : storageLensGroupOrOperatorMatchAnySuffixList) {
                                    xmlWriter.startElement("Suffix");
                                    xmlWriter.value(string);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((list3 = storageLensGroupOrOperator.getMatchAnyTag()) != null) {
                                xmlWriter.startElement("MatchAnyTag");
                                for (S3Tag storageLensGroupOrOperatorMatchAnyTagListValue : list3) {
                                    xmlWriter.startElement("Tag");
                                    if (storageLensGroupOrOperatorMatchAnyTagListValue.getKey() != null) {
                                        xmlWriter.startElement("Key").value(storageLensGroupOrOperatorMatchAnyTagListValue.getKey()).endElement();
                                    }
                                    if (storageLensGroupOrOperatorMatchAnyTagListValue.getValue() != null) {
                                        xmlWriter.startElement("Value").value(storageLensGroupOrOperatorMatchAnyTagListValue.getValue()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((matchObjectAge3 = storageLensGroupOrOperator.getMatchObjectAge()) != null) {
                                xmlWriter.startElement("MatchObjectAge");
                                if (matchObjectAge3.getDaysGreaterThan() != null) {
                                    xmlWriter.startElement("DaysGreaterThan").value((Object)matchObjectAge3.getDaysGreaterThan()).endElement();
                                }
                                if (matchObjectAge3.getDaysLessThan() != null) {
                                    xmlWriter.startElement("DaysLessThan").value((Object)matchObjectAge3.getDaysLessThan()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((matchObjectSize3 = storageLensGroupOrOperator.getMatchObjectSize()) != null) {
                                xmlWriter.startElement("MatchObjectSize");
                                if (matchObjectSize3.getBytesGreaterThan() != null) {
                                    xmlWriter.startElement("BytesGreaterThan").value((Object)matchObjectSize3.getBytesGreaterThan()).endElement();
                                }
                                if (matchObjectSize3.getBytesLessThan() != null) {
                                    xmlWriter.startElement("BytesLessThan").value((Object)matchObjectSize3.getBytesLessThan()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (storageLensGroup.getStorageLensGroupArn() != null) {
                        xmlWriter.startElement("StorageLensGroupArn").value(storageLensGroup.getStorageLensGroupArn()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((createStorageLensGroupRequestTagsList = createStorageLensGroupRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (Tag createStorageLensGroupRequestTagsListValue : createStorageLensGroupRequestTagsList) {
                        xmlWriter.startElement("Tag");
                        if (createStorageLensGroupRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(createStorageLensGroupRequestTagsListValue.getKey()).endElement();
                        }
                        if (createStorageLensGroupRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(createStorageLensGroupRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

