/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.RegionalBucket;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RegionalBucketStaxUnmarshaller
implements Unmarshaller<RegionalBucket, StaxUnmarshallerContext> {
    private static RegionalBucketStaxUnmarshaller instance;

    public RegionalBucket unmarshall(StaxUnmarshallerContext context) throws Exception {
        RegionalBucket regionalBucket = new RegionalBucket();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return regionalBucket;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Bucket", targetDepth)) {
                    regionalBucket.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BucketArn", targetDepth)) {
                    regionalBucket.setBucketArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PublicAccessBlockEnabled", targetDepth)) {
                    regionalBucket.setPublicAccessBlockEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    regionalBucket.setCreationDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OutpostId", targetDepth)) continue;
                regionalBucket.setOutpostId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return regionalBucket;
    }

    public static RegionalBucketStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RegionalBucketStaxUnmarshaller();
        }
        return instance;
    }
}

