/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AppNetworkAccessType;
import com.amazonaws.services.sagemaker.model.AppSecurityGroupManagement;
import com.amazonaws.services.sagemaker.model.DefaultSpaceSettings;
import com.amazonaws.services.sagemaker.model.DomainSettingsForUpdate;
import com.amazonaws.services.sagemaker.model.UserSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDomainRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainId;
    private UserSettings defaultUserSettings;
    private DomainSettingsForUpdate domainSettingsForUpdate;
    private String appSecurityGroupManagement;
    private DefaultSpaceSettings defaultSpaceSettings;
    private List<String> subnetIds;
    private String appNetworkAccessType;

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public UpdateDomainRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public void setDefaultUserSettings(UserSettings defaultUserSettings) {
        this.defaultUserSettings = defaultUserSettings;
    }

    public UserSettings getDefaultUserSettings() {
        return this.defaultUserSettings;
    }

    public UpdateDomainRequest withDefaultUserSettings(UserSettings defaultUserSettings) {
        this.setDefaultUserSettings(defaultUserSettings);
        return this;
    }

    public void setDomainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
        this.domainSettingsForUpdate = domainSettingsForUpdate;
    }

    public DomainSettingsForUpdate getDomainSettingsForUpdate() {
        return this.domainSettingsForUpdate;
    }

    public UpdateDomainRequest withDomainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
        this.setDomainSettingsForUpdate(domainSettingsForUpdate);
        return this;
    }

    public void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
        this.appSecurityGroupManagement = appSecurityGroupManagement;
    }

    public String getAppSecurityGroupManagement() {
        return this.appSecurityGroupManagement;
    }

    public UpdateDomainRequest withAppSecurityGroupManagement(String appSecurityGroupManagement) {
        this.setAppSecurityGroupManagement(appSecurityGroupManagement);
        return this;
    }

    public UpdateDomainRequest withAppSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
        this.appSecurityGroupManagement = appSecurityGroupManagement.toString();
        return this;
    }

    public void setDefaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
        this.defaultSpaceSettings = defaultSpaceSettings;
    }

    public DefaultSpaceSettings getDefaultSpaceSettings() {
        return this.defaultSpaceSettings;
    }

    public UpdateDomainRequest withDefaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
        this.setDefaultSpaceSettings(defaultSpaceSettings);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public UpdateDomainRequest withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public UpdateDomainRequest withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public void setAppNetworkAccessType(String appNetworkAccessType) {
        this.appNetworkAccessType = appNetworkAccessType;
    }

    public String getAppNetworkAccessType() {
        return this.appNetworkAccessType;
    }

    public UpdateDomainRequest withAppNetworkAccessType(String appNetworkAccessType) {
        this.setAppNetworkAccessType(appNetworkAccessType);
        return this;
    }

    public UpdateDomainRequest withAppNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
        this.appNetworkAccessType = appNetworkAccessType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getDefaultUserSettings() != null) {
            sb.append("DefaultUserSettings: ").append(this.getDefaultUserSettings()).append(",");
        }
        if (this.getDomainSettingsForUpdate() != null) {
            sb.append("DomainSettingsForUpdate: ").append(this.getDomainSettingsForUpdate()).append(",");
        }
        if (this.getAppSecurityGroupManagement() != null) {
            sb.append("AppSecurityGroupManagement: ").append(this.getAppSecurityGroupManagement()).append(",");
        }
        if (this.getDefaultSpaceSettings() != null) {
            sb.append("DefaultSpaceSettings: ").append(this.getDefaultSpaceSettings()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getAppNetworkAccessType() != null) {
            sb.append("AppNetworkAccessType: ").append(this.getAppNetworkAccessType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest)obj;
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getDefaultUserSettings() == null ^ this.getDefaultUserSettings() == null) {
            return false;
        }
        if (other.getDefaultUserSettings() != null && !other.getDefaultUserSettings().equals(this.getDefaultUserSettings())) {
            return false;
        }
        if (other.getDomainSettingsForUpdate() == null ^ this.getDomainSettingsForUpdate() == null) {
            return false;
        }
        if (other.getDomainSettingsForUpdate() != null && !other.getDomainSettingsForUpdate().equals(this.getDomainSettingsForUpdate())) {
            return false;
        }
        if (other.getAppSecurityGroupManagement() == null ^ this.getAppSecurityGroupManagement() == null) {
            return false;
        }
        if (other.getAppSecurityGroupManagement() != null && !other.getAppSecurityGroupManagement().equals(this.getAppSecurityGroupManagement())) {
            return false;
        }
        if (other.getDefaultSpaceSettings() == null ^ this.getDefaultSpaceSettings() == null) {
            return false;
        }
        if (other.getDefaultSpaceSettings() != null && !other.getDefaultSpaceSettings().equals(this.getDefaultSpaceSettings())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getAppNetworkAccessType() == null ^ this.getAppNetworkAccessType() == null) {
            return false;
        }
        return other.getAppNetworkAccessType() == null || other.getAppNetworkAccessType().equals(this.getAppNetworkAccessType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultUserSettings() == null ? 0 : this.getDefaultUserSettings().hashCode());
        hashCode = 31 * hashCode + (this.getDomainSettingsForUpdate() == null ? 0 : this.getDomainSettingsForUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getAppSecurityGroupManagement() == null ? 0 : this.getAppSecurityGroupManagement().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSpaceSettings() == null ? 0 : this.getDefaultSpaceSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getAppNetworkAccessType() == null ? 0 : this.getAppNetworkAccessType().hashCode());
        return hashCode;
    }

    public UpdateDomainRequest clone() {
        return (UpdateDomainRequest)super.clone();
    }
}

