/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.simpleemailv2.model.Recommendation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecommendationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Recommendation> recommendations;
    private String nextToken;

    public List<Recommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(Collection<Recommendation> recommendations) {
        if (recommendations == null) {
            this.recommendations = null;
            return;
        }
        this.recommendations = new ArrayList<Recommendation>(recommendations);
    }

    public ListRecommendationsResult withRecommendations(Recommendation ... recommendations) {
        if (this.recommendations == null) {
            this.setRecommendations(new ArrayList<Recommendation>(recommendations.length));
        }
        for (Recommendation ele : recommendations) {
            this.recommendations.add(ele);
        }
        return this;
    }

    public ListRecommendationsResult withRecommendations(Collection<Recommendation> recommendations) {
        this.setRecommendations(recommendations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecommendationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendations() != null) {
            sb.append("Recommendations: ").append(this.getRecommendations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsResult)) {
            return false;
        }
        ListRecommendationsResult other = (ListRecommendationsResult)obj;
        if (other.getRecommendations() == null ^ this.getRecommendations() == null) {
            return false;
        }
        if (other.getRecommendations() != null && !other.getRecommendations().equals(this.getRecommendations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendations() == null ? 0 : this.getRecommendations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRecommendationsResult clone() {
        try {
            return (ListRecommendationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

