/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.translate.model.Document;
import com.amazonaws.services.translate.model.TranslationSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TranslateDocumentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Document document;
    private List<String> terminologyNames;
    private String sourceLanguageCode;
    private String targetLanguageCode;
    private TranslationSettings settings;

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public TranslateDocumentRequest withDocument(Document document) {
        this.setDocument(document);
        return this;
    }

    public List<String> getTerminologyNames() {
        return this.terminologyNames;
    }

    public void setTerminologyNames(Collection<String> terminologyNames) {
        if (terminologyNames == null) {
            this.terminologyNames = null;
            return;
        }
        this.terminologyNames = new ArrayList<String>(terminologyNames);
    }

    public TranslateDocumentRequest withTerminologyNames(String ... terminologyNames) {
        if (this.terminologyNames == null) {
            this.setTerminologyNames(new ArrayList<String>(terminologyNames.length));
        }
        for (String ele : terminologyNames) {
            this.terminologyNames.add(ele);
        }
        return this;
    }

    public TranslateDocumentRequest withTerminologyNames(Collection<String> terminologyNames) {
        this.setTerminologyNames(terminologyNames);
        return this;
    }

    public void setSourceLanguageCode(String sourceLanguageCode) {
        this.sourceLanguageCode = sourceLanguageCode;
    }

    public String getSourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public TranslateDocumentRequest withSourceLanguageCode(String sourceLanguageCode) {
        this.setSourceLanguageCode(sourceLanguageCode);
        return this;
    }

    public void setTargetLanguageCode(String targetLanguageCode) {
        this.targetLanguageCode = targetLanguageCode;
    }

    public String getTargetLanguageCode() {
        return this.targetLanguageCode;
    }

    public TranslateDocumentRequest withTargetLanguageCode(String targetLanguageCode) {
        this.setTargetLanguageCode(targetLanguageCode);
        return this;
    }

    public void setSettings(TranslationSettings settings) {
        this.settings = settings;
    }

    public TranslationSettings getSettings() {
        return this.settings;
    }

    public TranslateDocumentRequest withSettings(TranslationSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocument() != null) {
            sb.append("Document: ").append(this.getDocument()).append(",");
        }
        if (this.getTerminologyNames() != null) {
            sb.append("TerminologyNames: ").append(this.getTerminologyNames()).append(",");
        }
        if (this.getSourceLanguageCode() != null) {
            sb.append("SourceLanguageCode: ").append(this.getSourceLanguageCode()).append(",");
        }
        if (this.getTargetLanguageCode() != null) {
            sb.append("TargetLanguageCode: ").append(this.getTargetLanguageCode()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateDocumentRequest)) {
            return false;
        }
        TranslateDocumentRequest other = (TranslateDocumentRequest)obj;
        if (other.getDocument() == null ^ this.getDocument() == null) {
            return false;
        }
        if (other.getDocument() != null && !other.getDocument().equals(this.getDocument())) {
            return false;
        }
        if (other.getTerminologyNames() == null ^ this.getTerminologyNames() == null) {
            return false;
        }
        if (other.getTerminologyNames() != null && !other.getTerminologyNames().equals(this.getTerminologyNames())) {
            return false;
        }
        if (other.getSourceLanguageCode() == null ^ this.getSourceLanguageCode() == null) {
            return false;
        }
        if (other.getSourceLanguageCode() != null && !other.getSourceLanguageCode().equals(this.getSourceLanguageCode())) {
            return false;
        }
        if (other.getTargetLanguageCode() == null ^ this.getTargetLanguageCode() == null) {
            return false;
        }
        if (other.getTargetLanguageCode() != null && !other.getTargetLanguageCode().equals(this.getTargetLanguageCode())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        return other.getSettings() == null || other.getSettings().equals(this.getSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocument() == null ? 0 : this.getDocument().hashCode());
        hashCode = 31 * hashCode + (this.getTerminologyNames() == null ? 0 : this.getTerminologyNames().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLanguageCode() == null ? 0 : this.getSourceLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLanguageCode() == null ? 0 : this.getTargetLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        return hashCode;
    }

    public TranslateDocumentRequest clone() {
        return (TranslateDocumentRequest)super.clone();
    }
}

