/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.externalconfig.ConfigLoader;
import com.aventstack.extentreports.externalconfig.model.Config;
import com.aventstack.extentreports.externalconfig.model.ConfigMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfigurableReporter
implements ExtentReporter {
    private static final Logger logger = Logger.getLogger(ConfigurableReporter.class.getName());
    protected ConfigMap configContext = new ConfigMap();

    public void loadXMLConfig(String filePath, Boolean silent) {
        this.loadXMLConfig(new File(filePath), silent);
    }

    public void loadXMLConfig(String filePath) {
        this.loadXMLConfig(filePath, (Boolean)false);
    }

    public void loadXMLConfig(File file, Boolean silent) {
        ConfigLoader configLoader = new ConfigLoader(file, silent);
        ConfigMap config = configLoader.getConfigurationHash();
        if (config != null) {
            config.getConfigList().forEach(this.configContext::setConfig);
        }
    }

    public void loadConfig(Properties properties) {
        properties.entrySet().forEach(o -> {
            Config c = new Config();
            c.setKey(o.getKey().toString());
            c.setValue(o.getValue());
            this.configContext.setConfig(c);
        });
    }

    public void loadConfig(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
            this.loadConfig(properties);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to load properties file", e);
        }
    }

    public void loadConfig(String filePath) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            this.loadConfig(is);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Default Properties file not found", e);
        }
    }

    public ConfigMap getConfigContext() {
        return this.configContext;
    }
}

